package com.tenqube.visual_third.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;

import static com.tenqube.visual_third.util.Utils.isSDKDisabled;


public class AlarmReceiver extends BroadcastReceiver {

    protected static final String TAG = AlarmReceiver.class.getSimpleName();
    public static final String ACTION_TENQUBE_NOTIFICATION = "RICH_ACTION_TENQUBE_NOTIFICATION";
    @Override
    public void onReceive(final Context context, Intent intent) {

        if(isSDKDisabled(context))
            return;

        if (Intent.ACTION_BOOT_COMPLETED.equals(intent.getAction()) ||
                Intent.ACTION_LOCKED_BOOT_COMPLETED.equals(intent.getAction())) {
            VisualAlarmManager.getInstance(context).setAlarms();
        } else if(ACTION_TENQUBE_NOTIFICATION.equals(intent.getAction())) {
            try {
                Bundle bundle = intent.getBundleExtra("bundle");
                if (bundle != null) {
                    VisualNotification notification = (VisualNotification) bundle.getSerializable("data");
                    if(notification != null) {
                        VisualNotificationManager.getInstance(context).showNotification(notification);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                VisualAlarmManager.getInstance(context).setAlarms();
            }
        }
    }

}
