/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.tenqube.visual_third.ActivityCallback;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.js.AddPaymentRequest;
import com.tenqube.visual_third.model.js.AddPaymentResponse;
import com.tenqube.visual_third.model.js.Cards;
import com.tenqube.visual_third.model.js.CategoryInfo;
import com.tenqube.visual_third.model.js.DeleteCardRequest;
import com.tenqube.visual_third.model.js.DeleteTranRequest;
import com.tenqube.visual_third.model.js.InsertTransactionRequest;
import com.tenqube.visual_third.model.js.Lv0Info;
import com.tenqube.visual_third.model.js.SaveStartDayRequest;
import com.tenqube.visual_third.model.js.SettingNotiRequest;
import com.tenqube.visual_third.model.js.SettingNotiResponse;
import com.tenqube.visual_third.model.js.Success;
import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.js.Transactions;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.VisualInterface;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.constants.Constants;

public class RepoImpl
extends Base
implements VisualInterface.Repo {
    private final VisualRepository repository;
    private final AnalysisService analysisService;
    private final VisualAlarmManager alarmManager;
    private boolean isProcessing = false;

    public RepoImpl(ActivityCallback activity, WebView webView, VisualInterface.Error error, VisualRepository repository, AnalysisService service, VisualAlarmManager alarmManager) {
        super(activity, webView, error);
        this.repository = repository;
        this.analysisService = service;
        this.alarmManager = alarmManager;
    }

    @Override
    @JavascriptInterface
    public String getSyncStatus() {
        return this.repository.getSyncStatus();
    }

    @Override
    @JavascriptInterface
    public void saveStartDay(final String params) {
        String funcName = "saveStartDay";
        new Thread(new Runnable(){

            @Override
            public void run() {
                SaveStartDayRequest saveStartDayRequest = null;
                try {
                    saveStartDayRequest = Utils.fromJson(params, SaveStartDayRequest.class);
                    saveStartDayRequest.checkParams();
                    RepoImpl.this.repository.saveStartDay(saveStartDayRequest.getStartDay());
                    RepoImpl.this.callback(saveStartDayRequest.getCallbackJS(), new Success(true));
                }
                catch (ParameterException e) {
                    RepoImpl.this.callback(saveStartDayRequest.getCallbackJS(), new Success(false));
                    RepoImpl.this.onError("saveStartDay", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("saveStartDay", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public int getStartDay() {
        return this.repository.getStartDay();
    }

    @Override
    @JavascriptInterface
    public void deleteTransactions(String params) {
        String funcName = "deleteTransactions";
        DeleteTranRequest deleteTranRequest = null;
        try {
            deleteTranRequest = Utils.fromJson(params, DeleteTranRequest.class);
            deleteTranRequest.checkParams();
            this.repository.updateDeletedTransactionById(deleteTranRequest.getIds());
            this.repository.syncTransactions(null);
            AnalysisServiceImpl.shouldRefresh = true;
            this.callback(deleteTranRequest.getCallbackJS(), new Success(true));
        }
        catch (Exception e) {
            if (deleteTranRequest != null) {
                this.callback(deleteTranRequest.getCallbackJS(), new Success(false));
            }
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void getCategories(final String callback) {
        String funcName = "getCategories";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    ArrayList<CategoryInfo.ServerCategory> serverCategories = RepoImpl.this.repository.loadCategories();
                    ArrayList<CategoryInfo.UserCategory> userCategories = RepoImpl.this.repository.loadUserCategories();
                    CategoryInfo categoryInfo = new CategoryInfo(serverCategories, userCategories);
                    RepoImpl.this.callback(callback, categoryInfo);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getCategories", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("getCategories", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getCards(final String callback) {
        String funcName = "getCards";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    ArrayList<Cards.Card> cardList = RepoImpl.this.repository.loadCards();
                    Cards cards = new Cards(cardList);
                    RepoImpl.this.callback(callback, cards);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getCards", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("getCards", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void deleteCardsByIds(String params) {
        String funcName = "deleteCardsByIds";
        DeleteCardRequest request = null;
        try {
            request = Utils.fromJson(params, DeleteCardRequest.class);
            request.checkParams();
            List<Integer> tranIds = this.repository.findTransactionIdsByCardIds(request.getIds());
            if (tranIds.isEmpty()) {
                this.repository.deleteCardsByIds(request.getIds());
                AnalysisServiceImpl.shouldRefresh = true;
                this.callback(request.getCallbackJS(), new Success(true));
            } else {
                this.repository.updateDeletedTransactionById((Integer[])tranIds.toArray());
                final DeleteCardRequest finalRequest = request;
                this.repository.syncTransactions(new OnNetworkResultListener(){

                    public void onResult(boolean isSuccess) {
                        RepoImpl.this.repository.deleteCardsByIds(finalRequest.getIds());
                        AnalysisServiceImpl.shouldRefresh = true;
                        RepoImpl.this.callback(finalRequest.getCallbackJS(), new Success(true));
                    }
                });
            }
        }
        catch (Exception e) {
            if (request != null) {
                this.callback(request.getCallbackJS(), new Success(false));
            }
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void getTransactions(final String params) {
        String funcName = "getTransactions";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionRequest transactionRequest = Utils.fromJson(params, TransactionRequest.class);
                    transactionRequest.checkParams();
                    transactionRequest.setDwType(-1);
                    transactionRequest.setExceptType(-1);
                    Log.i((String)"getTransactions", (String)("WEB" + transactionRequest.toString()));
                    ArrayList<Transactions.Transaction> tranList = RepoImpl.this.repository.loadTransactions(transactionRequest);
                    Transactions transactions = new Transactions(tranList);
                    RepoImpl.this.callback(transactionRequest.getCallbackJS(), transactions);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getTransactions", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("getTransactions", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getTransactionsByIds(final String params) {
        String funcName = "getTransactionsByIds";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionByIdsRequest transactionRequest = Utils.fromJson(params, TransactionByIdsRequest.class);
                    transactionRequest.checkParams();
                    ArrayList<Transactions.Transaction> tranList = RepoImpl.this.repository.loadTransactions(transactionRequest);
                    Transactions transactions = new Transactions(tranList);
                    RepoImpl.this.callback(transactionRequest.getCallbackJS(), transactions);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getTransactionsByIds", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("getTransactionsByIds", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getLv0Contents(final String callback) {
        String funcName = "getLv0Contents";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    Calendar calendar = Calendar.getInstance();
                    int day = calendar.get(5);
                    if (day < RepoImpl.this.repository.getStartDay()) {
                        calendar.add(2, -1);
                    }
                    int year = calendar.get(1);
                    int month = calendar.get(2) + 1;
                    TransactionRequest request = new TransactionRequest(year, month, 3, true, "");
                    request.setDwType(Constants.DWType.WITHDRAW.ordinal());
                    request.setExceptType(0);
                    ArrayList<Transaction> transactions = RepoImpl.this.repository.loadAnalysisTransactions(request);
                    Lv0Info lv0Info = new Lv0Info(new ArrayList<Lv0Info.Lv0>());
                    if (!Utils.isEmpty(transactions)) {
                        ArrayList<Analysis> analyses = RepoImpl.this.analysisService.loadAnalysisList(transactions, RepoImpl.this.repository.getStartDay(), false);
                        ArrayList<Lv0Info.Lv0> lv0s = Mapper.toLv0s(analyses);
                        lv0Info.setSuccess(lv0s);
                    }
                    RepoImpl.this.callback(callback, lv0Info);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getLv0Contents", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("getLv0Contents", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void insertTransaction(final String params) {
        if (!this.isProcessing) {
            this.isProcessing = true;
            String funcName = "insertTransaction";
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InsertTransactionRequest insertTransactionRequest = null;
                    try {
                        insertTransactionRequest = Utils.fromJson(params, InsertTransactionRequest.class);
                        insertTransactionRequest.checkParams();
                        int id2 = RepoImpl.this.repository.insertTransaction(insertTransactionRequest);
                        if (id2 == 0) {
                            RepoImpl.this.callback(insertTransactionRequest.getCallbackJS(), new Success(false));
                            return;
                        }
                        insertTransactionRequest.setTranId(id2);
                        JoinedTransaction joinedTransaction = RepoImpl.this.repository.loadJoinedTransaction(insertTransactionRequest.getTranId());
                        SearchCompanyRequest.Transaction transaction = new SearchCompanyRequest.Transaction(joinedTransaction);
                        transaction.setlCode(insertTransactionRequest.getlCode());
                        transaction.setmCode(insertTransactionRequest.getmCode());
                        ArrayList<SearchCompanyRequest.Transaction> transactions = new ArrayList<SearchCompanyRequest.Transaction>();
                        transactions.add(transaction);
                        SearchCompanyResponse response = RepoImpl.this.repository.searchCompany(new SearchCompanyRequest(transactions));
                        if (response != null && response.getResults().size() > 0) {
                            RepoImpl.this.repository.updateTransaction(response.getResults().get(0), false);
                            RepoImpl.this.repository.syncTransactions(null);
                        }
                        AnalysisServiceImpl.shouldRefresh = true;
                        RepoImpl.this.callback(insertTransactionRequest.getCallbackJS(), new Success(true));
                    }
                    catch (ParameterException e) {
                        RepoImpl.this.callback(insertTransactionRequest.getCallbackJS(), new Success(false));
                        RepoImpl.this.onError("insertTransaction", e.toString());
                    }
                    catch (Exception e) {
                        RepoImpl.this.onError("insertTransaction", e.toString());
                    }
                    finally {
                        RepoImpl.this.isProcessing = false;
                    }
                }
            }).start();
        }
    }

    @Override
    @JavascriptInterface
    public void updateTransaction(final String params) {
        String funcName = "updateTransaction";
        if (!this.isProcessing) {
            this.isProcessing = true;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    UpdateTransactionRequest updateTransactionRequest = null;
                    try {
                        updateTransactionRequest = Utils.fromJson(params, UpdateTransactionRequest.class);
                        updateTransactionRequest.checkParams();
                        RepoImpl.this.repository.updateTransaction(updateTransactionRequest);
                        JoinedTransaction joinedTransaction = RepoImpl.this.repository.loadJoinedTransaction(updateTransactionRequest.getTranId());
                        SearchCompanyRequest.Transaction transaction = new SearchCompanyRequest.Transaction(joinedTransaction);
                        transaction.setlCode(updateTransactionRequest.getlCode());
                        transaction.setmCode(updateTransactionRequest.getmCode());
                        ArrayList<SearchCompanyRequest.Transaction> transactions = new ArrayList<SearchCompanyRequest.Transaction>();
                        transactions.add(transaction);
                        SearchCompanyResponse response = RepoImpl.this.repository.searchCompany(new SearchCompanyRequest(transactions));
                        if (response != null && response.getResults().size() > 0) {
                            RepoImpl.this.repository.updateTransaction(response.getResults().get(0), updateTransactionRequest.isAll());
                            RepoImpl.this.repository.syncTransactions(null);
                        }
                        AnalysisServiceImpl.shouldRefresh = true;
                        RepoImpl.this.callback(updateTransactionRequest.getCallbackJS(), new Success(true));
                    }
                    catch (ParameterException e) {
                        RepoImpl.this.callback(updateTransactionRequest.getCallbackJS(), new Success(false));
                        RepoImpl.this.onError("updateTransaction", e.toString());
                    }
                    catch (Exception e) {
                        RepoImpl.this.onError("updateTransaction", e.toString());
                    }
                    finally {
                        RepoImpl.this.isProcessing = false;
                    }
                }
            }).start();
        }
    }

    @Override
    @JavascriptInterface
    public boolean shouldShowTranPopup() {
        return this.repository.isActiveTranPopup();
    }

    @Override
    @JavascriptInterface
    public void setTranPopup(boolean shouldShow) {
        this.repository.setTranPopup(shouldShow);
    }

    @Override
    @JavascriptInterface
    public void settingNotification(final String params) {
        String funcName = "settingNotification";
        new Thread(new Runnable(){

            @Override
            public void run() {
                SettingNotiRequest settingNotiRequest = null;
                try {
                    settingNotiRequest = Utils.fromJson(params, SettingNotiRequest.class);
                    settingNotiRequest.checkParams();
                    RepoImpl.this.repository.setActiveNoti(settingNotiRequest.getName().contains("weekly") ? "weekly" : settingNotiRequest.getName(), settingNotiRequest.isEnabled());
                    if (settingNotiRequest.getHour() != null) {
                        RepoImpl.this.repository.updateNotiHour(settingNotiRequest.getName(), settingNotiRequest.getHour());
                    }
                    RepoImpl.this.alarmManager.setAlarms();
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("settingNotification", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("settingNotification", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getNotificationSettings(final String callback) {
        String funcName = "getNotificationSettings";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.notNull(callback);
                    ArrayList<VisualNotification> notifications = RepoImpl.this.repository.loadNotifications();
                    if (Utils.isEmpty(notifications)) {
                        throw new ParameterException("empty");
                    }
                    ArrayList<SettingNotiRequest> settings = new ArrayList<SettingNotiRequest>();
                    for (VisualNotification notification : notifications) {
                        settings.add(new SettingNotiRequest(notification.getName(), notification.isEnable(), notification.getHour()));
                    }
                    SettingNotiResponse res = new SettingNotiResponse(settings);
                    RepoImpl.this.callback(callback, res);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getNotificationSettings", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("getNotificationSettings", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void initialize(final String callback) {
        String funcName = "initialize";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.notNull(callback);
                    RepoImpl.this.repository.initialize(new Callback<Boolean>(){

                        @Override
                        public void onDataLoaded(Boolean value) {
                            AnalysisServiceImpl.shouldRefresh = true;
                            RepoImpl.this.callback(callback, new Success(value));
                        }
                    });
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("initialize", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("initialize", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void signOut(final String callback) {
        String funcName = "signOut";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.notNull(callback);
                    RepoImpl.this.repository.signOut(new Callback<Boolean>(){

                        @Override
                        public void onDataLoaded(Boolean value) {
                            AnalysisServiceImpl.shouldRefresh = true;
                            RepoImpl.this.callback(callback, new Success(value));
                            RepoImpl.this.activity.getActivity().finish();
                        }
                    });
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("signOut", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("signOut", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void addPayment(final String params) {
        String funcName = "addPayment";
        new Thread(new Runnable(){

            @Override
            public void run() {
                AddPaymentRequest addPaymentRequest = null;
                int id2 = -1;
                try {
                    addPaymentRequest = Utils.fromJson(params, AddPaymentRequest.class);
                    addPaymentRequest.checkParams();
                    id2 = RepoImpl.this.repository.insertCard(addPaymentRequest.getName(), addPaymentRequest.getType());
                    RepoImpl.this.callback(addPaymentRequest.getCallbackJS(), new AddPaymentResponse(id2));
                }
                catch (ParameterException e) {
                    RepoImpl.this.callback(addPaymentRequest.getCallbackJS(), new AddPaymentResponse(id2));
                    RepoImpl.this.onError("addPayment", e.toString());
                }
                catch (Exception e) {
                    RepoImpl.this.onError("addPayment", e.toString());
                }
            }
        }).start();
    }
}

