/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;
import com.tenqube.visual_third.R;

public class NotiIntroActivity
extends Activity {
    public static final String TAG = "NotiIntroActivity";
    private Switch switch1;
    private boolean mEnable;
    private Handler handler;
    private Runnable repeatRunnable = new Runnable(){

        @Override
        public void run() {
            NotiIntroActivity.this.setSwitch(NotiIntroActivity.this.switch1);
            if (!NotiIntroActivity.this.isFinishing()) {
                NotiIntroActivity.this.handler.postDelayed((Runnable)this, 2000L);
            }
            NotiIntroActivity.this.mEnable = !NotiIntroActivity.this.mEnable;
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.visual_activity_noti_intro);
        this.setAppInfo();
        Button nextButton = (Button)this.findViewById(R.id.next);
        this.switch1 = (Switch)this.findViewById(R.id.visual_switch_1);
        this.startAnimation();
        nextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NotiIntroActivity.this.finish();
            }
        });
    }

    private void setAppInfo() {
        PackageManager packageManager = this.getApplicationContext().getPackageManager();
        try {
            ImageView logoImageView = (ImageView)this.findViewById(R.id.visual_logo);
            TextView appNameTextView = (TextView)this.findViewById(R.id.visual_app_name);
            String pkgName = this.getApplicationContext().getPackageName();
            ApplicationInfo appInfo = packageManager.getApplicationInfo(pkgName, 128);
            Drawable icon = packageManager.getApplicationIcon(pkgName);
            logoImageView.setImageDrawable(icon);
            String appName = (String)packageManager.getApplicationLabel(appInfo);
            appNameTextView.setText((CharSequence)appName);
            TextView descTextView = (TextView)this.findViewById(R.id.visual_description);
            descTextView.setText((CharSequence)this.getString(R.string.visual_notification_catch_dialog_title, new Object[]{appName}));
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private void startAnimation() {
        if (this.switch1 != null) {
            this.switch1.setChecked(!this.mEnable);
        }
        this.handler = new Handler();
        this.handler.postDelayed(this.repeatRunnable, 600L);
    }

    private void setSwitch(final Switch switch1) {
        if (switch1 != null) {
            if (!this.mEnable) {
                switch1.setVisibility(4);
                switch1.setChecked(this.mEnable);
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        switch1.setVisibility(0);
                    }
                }, 250L);
            } else {
                switch1.setChecked(true);
            }
        }
    }
}

