/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.text.TextUtils;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Card;
import java.util.ArrayList;
import java.util.List;
import tenqube.parser.constants.Constants;

public class CardDao {
    private final Db db;

    public CardDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Card> loadCards() {
        String query = QueryGenerator.card();
        ArrayList<Card> results = new ArrayList<Card>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.CardTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCardId(String cardName, int cardType, int cardSubType) {
        String query = QueryGenerator.cardId();
        String[] values = new String[]{cardName, cardType + "", cardSubType + ""};
        try (Cursor c = null;){
            c = this.db.runQuery(query, values);
            if (c != null && c.moveToFirst()) {
                int n = c.getInt(c.getColumnIndex("cId"));
                return n;
            }
        }
        return -1;
    }

    public int insert(String cardName, int cardType, int cardSubType) {
        try {
            ContentValues values = new ContentValues();
            values.put("cardName", cardName);
            values.put("cardType", Integer.valueOf(cardType));
            values.put("cardSubType", Integer.valueOf(cardSubType));
            values.put("changeName", cardName);
            values.put("changeType", Integer.valueOf(cardType));
            values.put("changeSubType", Integer.valueOf(cardSubType));
            return (int)this.db.insert(" CARDS", values);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void insertCash() {
        try {
            this.db.insert(" CARDS", ReaderContract.CardTable.populateData());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteAll() {
        try {
            this.db.delete(" CARDS", null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteCardsByIds(List<Integer> ids) {
        try {
            this.db.delete(" CARDS", "cId IN (" + TextUtils.join((CharSequence)",", ids) + ")", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteCardsByNotInIds(List<Integer> ids) {
        try {
            this.db.delete(" CARDS", "cId NOT IN (" + TextUtils.join((CharSequence)",", ids) + ") " + " AND  " + "cardType" + " != " + Constants.CardType.CASH.ordinal(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteCardsExceptCache() {
        try {
            this.db.delete(" CARDS", "cardType != " + Constants.CardType.CASH.ordinal(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

