package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;

import java.util.ArrayList;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class CategoryDao {

    private final Db db;

    public CategoryDao(Db db) {
        this.db = db;
    }

    public void loadAll() {

        String query = QueryGenerator.category();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        LOGI("LOADALL", ReaderContract.CategoryTable.populateModel(c).toString(), mIsDebug);
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }
    }


    public ArrayList<Category> loadCategories() {

        String query = QueryGenerator.categoryByMedium();
        ArrayList<Category> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.CategoryTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public Category loadCategory(String categoryCode) {

        String query = QueryGenerator.category(categoryCode);
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        return ReaderContract.CategoryTable.populateModel(c);
                    }
                }
            }
        } catch (SQLiteException e) {
            e.printStackTrace();
        } finally {
            if(c != null) {
                c.close();
            }
        }

        return null;
    }

    public void mergeCategory(SyncCategoryResponse.Category category) {

        try {
            if(category.isDeleted()) {
                db.delete(ReaderContract.CategoryTable.TABLE_NAME, ReaderContract.CategoryTable._ID + "=?" , new String[]{category.getId() + ""});
            } else {
                ContentValues values = new ContentValues();
                values.put(ReaderContract.CategoryTable._ID, category.getId());
                values.put(ReaderContract.CategoryTable.COLUMN_CODE, category.getCategoryCode());
                values.put(ReaderContract.CategoryTable.COLUMN_LARGE, category.getLargeCategory());
                values.put(ReaderContract.CategoryTable.COLUMN_MEDIUM, category.getMediumCategory());
                values.put(ReaderContract.CategoryTable.COLUMN_SMALL, category.getSmallCategory());
                db.insertOnReplace(ReaderContract.CategoryTable.TABLE_NAME, values);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
