package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.SenderTransaction;

import java.util.ArrayList;
import java.util.List;

public class SenderTransactionDao {

    private final Db db;

    public SenderTransactionDao(Db db) {
        this.db = db;
    }

    public List<SenderTransaction> loadSendersByIdentifiers(List<String> ids) {

        if(ids.isEmpty()) return new ArrayList<>();

        String query = QueryGenerator.senderTransactionByIds(ids);
        ArrayList<SenderTransaction> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.SenderTransactionTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }


    public int insert(String sender, String identifier) {

        try {
            if(TextUtils.isEmpty(sender) || TextUtils.isEmpty(identifier)) {
                return 0;
            }

            ContentValues values = new ContentValues();
            values.put(ReaderContract.SenderTransactionTable.COLUMN_SENDER, sender);
            values.put(ReaderContract.SenderTransactionTable.COLUMN_TRAN_IDENTIFIER, identifier);
            values.put(ReaderContract.SenderTransactionTable.COLUMN_CREATED_AT, System.currentTimeMillis());
            return (int) db.insert(ReaderContract.SenderTransactionTable.TABLE_NAME, values);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return 0;

    }

    public void deleteAll() {
        try {
            db.delete(ReaderContract.SenderTransactionTable.TABLE_NAME, null, null);
        } catch (Exception e) {

        }
    }

}
