package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.notNull;

public class SettingNotiRequest extends Request implements Serializable {

    private final String name;

    private final boolean enabled;

    private final Integer hour;

    public SettingNotiRequest(String name, boolean enabled, Integer hour) {
        this.name = name;
        this.enabled = enabled;
        this.hour = hour;
    }

    @Override
    public void checkParams() throws ParameterException {
        notNull(name);
    }

    public String getName() {
        return name;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public Integer getHour() {
        return hour;
    }
}
