package com.tenqube.visual_third.api;

import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.SyncClipCategoryResponse;
import com.tenqube.visual_third.model.api.VersionResponse;

import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Query;
import tenqube.parser.model.ParsingRule;

interface ResourceApiService {

    String CATEGORY = "category";
    String CLIP_CATEGORY = "clipCategory";
    String ANALYSIS = "analysis";
    String PARSING_RULE = "parsingRule";

    String SERVICE = "clip";
    String BASE_URL = "https://73978j1585.execute-api.ap-northeast-2.amazonaws.com/%1$s/";

    @GET("resource/version")
    Call<VersionResponse> syncVersion(@Header("x-api-key") String apiKey,
                                      @Header("service") String service);

    @GET("resource")
    Call<SyncCategoryResponse> syncCategory(@Header("x-api-key") String apiKey,
                                            @Header("service") String service,

                                            @Query("type") String type,
                                            @Query("clientVersion") int clientVersion,
                                            @Query("serverVersion") int serverVersion);

    @GET("resource")
    Call<SyncClipCategoryResponse> syncClipCategory(@Header("x-api-key") String apiKey,
                                                    @Header("service") String service,
                                                    @Query("type") String type,
                                                    @Query("clientVersion") int clientVersion,
                                                    @Query("serverVersion") int serverVersion);
    @GET("resource")
    Call<ParsingRule> syncParsingRule(@Header("x-api-key") String apiKey,
                                      @Header("service") String service,
                                      @Query("type") String type,
                                      @Query("clientVersion") int clientVersion,
                                      @Query("serverVersion") int serverVersion);

    @GET("resource/parsing-rule/key")
    Call<ParsingRuleKey> syncParsingRuleKey(@Header("x-api-key") String apiKey,
                                            @Header("service") String service);

    @GET("resource")
    Call<AnalysisResponse> syncAnalysis(@Header("x-api-key") String apiKey,
                                        @Header("service") String service,
                                        @Query("type") String type,
                                        @Query("clientVersion") int clientVersion,
                                        @Query("serverVersion") int serverVersion);

    @GET("resource/notification")
    Call<NotificationResponse> syncNotification(@Header("x-api-key") String apiKey);


}
