package com.tenqube.visual_third.manager.sms;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;

import java.util.ArrayList;

import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

import static com.tenqube.visual_third.util.Utils.getConvertedDate;

public class SmsLoader {

    private final Context mContext;

    public SmsLoader(Context mContext) {
        this.mContext = mContext;
    }

    public ArrayList<SMS> findAll() {
        ArrayList<SMS> results = new ArrayList<>();

        try {

            Uri uri = Uri.parse("content://sms/inbox");
            Cursor mCursor = mContext.getContentResolver().query(uri, null, null, null, "date asc");
            if (mCursor != null) {
                mCursor.moveToFirst();
                SMS sms = null;
                while (!mCursor.isAfterLast()) {
                    sms = new SMS(mCursor.getInt(mCursor.getColumnIndex("_id")),
                            mCursor.getString(mCursor.getColumnIndex("body")),
                            mCursor.getString(mCursor.getColumnIndex("address")),
                            mCursor.getString(mCursor.getColumnIndex("address")),
                            getConvertedDate(mCursor.getLong(mCursor.getColumnIndex("date"))),
                            Constants.SMSType.SMS.ordinal());

                    results.add(sms);
                    mCursor.moveToNext();
                }
            }
        } catch (Exception e) {

        }

        return results;
    }
}
