package com.tenqube.visual_third;

import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;

import com.tenqube.visual_third.exception.ParameterException;

public interface VisualService {

    /**
     * @param activity activity
     * @param containerId fragment 컨테이너 정보
     * @param isBackStack 백스택 여부
     * @param uid 사용자 유니크 아이디
     * @param path web 경로 (딥링크시 사용)
     * @throws ParameterException 파라미터가 올바르지 않은 경우
     * @throws SecurityException 보안 예외 추가
     */
    void startVisual(@NonNull final AppCompatActivity activity, final int containerId, final boolean isBackStack, @NonNull String uid, @NonNull String path) throws ParameterException, SecurityException;

    /**
     * 팝업에서 상세보기 버튼 클릭시 재무진단 탭으로 이동시켜줄 딥링크 정보
     * ex) visual://main?path="재무진단"
     * url = visual://main 이 url에 알맞습니다.
     * @param url 딥링크 정보
     */
    void setDeepLink(String url);

    /**
     * 팝업 보여질지 여부를 확인 합니다.
     * @return 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    boolean isActiveTranPopup();

    /**
     * 팝업 호출 여부
     * @param isActive 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    void setTranPopup(boolean isActive);
    /**
     * 로그 확인을 위한 디버그 적용 함수
     * @param isDebug 디버그 여부
     */
    void setDebugMode(boolean isDebug);

    /**
     * SDK초기화 함수 개발 전용
     */
    void initSDK();

    /**
     * SDK 사용 여부 판단 플레그
     * @param enabled true : 동작 / false : 동작 안함.
     */
    void setEnabled(boolean enabled);

    /**
     * 알림 설정 정보
     * @param smallIcon 알림 설정 아이콘
     */
    void settingNotification(int smallIcon);

    /**
     * 월간알림 활성화
     * @param isActive 활성화 여부
     */
    void setMonthlyNoti(boolean isActive);

    /**
     * 월간알림 활성화 여부 확인
     * @return 활성화 여부
     */
    boolean isActiveMonthlyNoti();

    /**
     * 주간알림 활성화
     * @param isActive 활성화 여부
     */
    void setWeeklyNoti(boolean isActive);

    /**
     * 주간알림 활성화 여부 확인
     * @return 활성화 여부
     */
    boolean isActiveWeeklyNoti();

    /**
     * 일간알림 활성화
     * @param isActive 활성화 여부
     */
    void setDailyNoti(boolean isActive);

    /**
     * 일간알림 활성화 여부 확인
     * @return 활성화 여부
     */
    boolean isActiveDailyNoti();

    /**
     * 사용자 이름 설정
     * @param userName 사용자 이름
     */
    void setUserName(String userName);
}
