/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager.migration;

import android.text.TextUtils;
import android.util.SparseArray;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.migration.MigrationCallback;
import com.tenqube.visual_third.manager.sms.SmsLoader;
import com.tenqube.visual_third.model.parser.MigrationCard;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.AppExecutors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tenqube.parser.Parser;
import tenqube.parser.constants.Constants;
import tenqube.parser.model.RegData;
import tenqube.parser.model.SMS;
import tenqube.parser.util.Validator;

public class Migration {
    public static final int VERSION = 1;
    private final PrefManager prefManager;
    private final VisualRepository visualRepository;
    private final SmsLoader smsLoader;
    private final Parser parser;
    private final AppExecutors appExecutors;
    private int total = 100;
    private int current;

    public Migration(PrefManager prefManager, VisualRepository visualRepository, SmsLoader smsLoader, Parser parser, AppExecutors appExecutors) {
        this.prefManager = prefManager;
        this.visualRepository = visualRepository;
        this.smsLoader = smsLoader;
        this.parser = parser;
        this.appExecutors = appExecutors;
    }

    public void card(final MigrationCallback callback) {
        this.appExecutors.diskIO().execute(new Runnable(){

            @Override
            public void run() {
                if (!Migration.this.checkAlreadyMigrated()) {
                    Migration.this.appExecutors.mainThread().execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onStart();
                        }
                    });
                    Migration.this.onProgress(callback, 1, Migration.this.total);
                    HashMap smsMap = Migration.this.getSmsMap();
                    ArrayList transactions = Migration.this.getTransactions();
                    Migration.this.onProgress(callback, 10, Migration.this.total);
                    SparseArray regData = Migration.this.getRegData(transactions);
                    Migration.this.onProgress(callback, 20, Migration.this.total);
                    ArrayList parsedResults = Migration.this.parsing(transactions, (SparseArray<RegData>)regData, smsMap);
                    Migration.this.onProgress(callback, 30, Migration.this.total);
                    Migration.this.removeCardsExceptCache(parsedResults, transactions);
                    Migration.this.onProgress(callback, 50, Migration.this.total);
                    Migration.this.setCardId(parsedResults);
                    Migration.this.onProgress(callback, 70, Migration.this.total);
                    Migration.this.updateTransactionsByCards(parsedResults);
                    Migration.this.onProgress(callback, 90, Migration.this.total);
                    Migration.this.saveMigratedVersion(1);
                    Migration.this.onProgress(callback, 100, Migration.this.total);
                }
                Migration.this.appExecutors.mainThread().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCompleted();
                    }
                });
            }
        });
    }

    private void onProgress(final MigrationCallback callback, final int current, final int total) {
        this.appExecutors.mainThread().execute(new Runnable(){

            @Override
            public void run() {
                callback.onProgress(current, total);
            }
        });
    }

    private boolean checkAlreadyMigrated() {
        return this.prefManager.loadIntValue("TENQUBE_VISUAL_MIGRATION_VERSION", 0) == 1;
    }

    private HashMap<String, ArrayList<SMS>> getSmsMap() {
        HashMap<String, ArrayList<SMS>> smsMap = new HashMap<String, ArrayList<SMS>>();
        ArrayList<SMS> smsList = this.smsLoader.findAll();
        for (SMS sms : smsList) {
            ArrayList<Object> smsItems = smsMap.get(sms.getSmsDate());
            if (smsItems == null) {
                smsItems = new ArrayList();
            }
            smsItems.add(sms);
            smsMap.put(sms.getSmsDate(), smsItems);
        }
        return smsMap;
    }

    private String makeSmsKey(SMS sms) {
        return sms.getSmsDate();
    }

    private ArrayList<JoinedTransaction> getTransactions() {
        return this.visualRepository.loadJoinedTransactions();
    }

    private SparseArray<RegData> getRegData(ArrayList<JoinedTransaction> transactions) {
        ArrayList<Integer> regIds = new ArrayList<Integer>();
        for (JoinedTransaction transaction : transactions) {
            regIds.add(transaction.getTransaction().getRegId());
        }
        if (regIds.isEmpty()) {
            return new SparseArray();
        }
        SparseArray hashMap = new SparseArray();
        ArrayList results = this.parser.getParsingRule(regIds);
        for (RegData reg : results) {
            hashMap.put(reg.regId, (Object)reg);
        }
        return hashMap;
    }

    private ArrayList<MigrationCard> parsing(ArrayList<JoinedTransaction> transactions, SparseArray<RegData> regData, HashMap<String, ArrayList<SMS>> smsMap) {
        ArrayList<MigrationCard> results = new ArrayList<MigrationCard>();
        block0: for (JoinedTransaction transaction : transactions) {
            ArrayList<SMS> smsList = smsMap.get(transaction.getTransaction().getSmsDate());
            if (smsList == null) continue;
            for (SMS sms : smsList) {
                String cardNum;
                String cardName;
                RegData reg = (RegData)regData.get(transaction.getTransaction().getRegId());
                if (reg == null) continue;
                String fullSms = this.transformFullSMS(sms.getFullSms());
                Pattern pattern = Pattern.compile(reg.regExpression, 106);
                Matcher matcher = pattern.matcher(fullSms);
                if (!matcher.matches()) continue;
                String parsedCardName = this.getCardName(this.getParsedData(reg.cardName, matcher));
                String string2 = cardName = TextUtils.isEmpty((CharSequence)parsedCardName) || parsedCardName.contains("null") ? "\ub0b4\uc6a9\uc5c6\uc74c" : parsedCardName.trim();
                if (cardName == null) {
                    cardName = "";
                }
                if ((cardNum = this.getCardNum(reg.cardNum, matcher)) == null) {
                    cardNum = "";
                }
                int cardType = this.getCardType(reg.cardType, matcher);
                int cardSubType = this.getCardSubType(reg.cardSubType, matcher);
                results.add(new MigrationCard(transaction.getTransaction().getIdentifier(), cardName, cardNum, cardType, cardSubType));
                continue block0;
            }
        }
        return results;
    }

    private void removeCardsExceptCache(ArrayList<MigrationCard> parseResults, ArrayList<JoinedTransaction> transactions) {
        ArrayList<Integer> notMatchedCardId = new ArrayList<Integer>();
        ArrayList<Long> identifiers = new ArrayList<Long>();
        for (MigrationCard card : parseResults) {
            identifiers.add(card.identifier);
        }
        for (JoinedTransaction transaction : transactions) {
            if (identifiers.indexOf(transaction.getTransaction().getIdentifier()) != -1) continue;
            notMatchedCardId.add(transaction.getCard().getId());
        }
        HashSet notMatchedUniqueCardIds = new HashSet(notMatchedCardId);
        this.visualRepository.deleteCardsByIds(new ArrayList<Integer>(notMatchedUniqueCardIds));
    }

    private ArrayList<MigrationCard> setCardId(ArrayList<MigrationCard> cards) {
        for (MigrationCard card : cards) {
            card.cardId = this.visualRepository.loadCardId(card.getCardFullName(), card.cardType, card.cardSubType);
        }
        return cards;
    }

    private void updateTransactionsByCards(ArrayList<MigrationCard> cards) {
        this.visualRepository.updateTransactionCards(cards);
    }

    private int getCardType(String cardType, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)cardType) && Validator.isNumber((String)cardType) ? this.getCardTypeStr(this.getMatcher(Integer.parseInt(cardType), matcher)) : this.getCardTypeStr(cardType);
    }

    private int getCardTypeStr(String cardType) {
        if (TextUtils.isEmpty((CharSequence)cardType)) {
            return Constants.CardType.CARD.ordinal();
        }
        if ("\uccb4\ud06c".equals(cardType)) {
            return Constants.CardType.CHECK.ordinal();
        }
        if ("\uc740\ud589".equals(cardType)) {
            return Constants.CardType.BANK_ACCOUNT.ordinal();
        }
        return Constants.CardType.CARD.ordinal();
    }

    private int getCardSubType(String cardSubType, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)cardSubType) && Validator.isNumber((String)cardSubType) ? this.getCardSubTypeStr(this.getMatcher(Integer.parseInt(cardSubType), matcher)) : this.getCardSubTypeStr(cardSubType);
    }

    private int getCardSubTypeStr(String cardSubType) {
        if (TextUtils.isEmpty((CharSequence)cardSubType)) {
            return Constants.CardSubType.NORMAL.ordinal();
        }
        if ("\ubc95\uc778".equals(cardSubType)) {
            return Constants.CardSubType.CORPORATION.ordinal();
        }
        if ("\uac00\uc871".equals(cardSubType)) {
            return Constants.CardSubType.FAMILY.ordinal();
        }
        return Constants.CardSubType.NORMAL.ordinal();
    }

    private String getCardNumUntilFour(String cardNum) {
        if (TextUtils.isEmpty((CharSequence)cardNum)) {
            return "";
        }
        cardNum = cardNum.replace("(", "");
        cardNum = cardNum.replace(")", "");
        cardNum = cardNum.replace("-", "");
        cardNum = cardNum.replace("X", "*");
        cardNum = cardNum.replace("#", "*");
        return (cardNum = cardNum.replaceAll(" ", "")).length() > 4 ? "(" + cardNum.substring(cardNum.length() - 4) + ")" : "(" + cardNum + ")";
    }

    private String getCardNum(String cardNum, Matcher matcher) {
        return !TextUtils.isEmpty((CharSequence)cardNum) && Validator.isNumber((String)cardNum) ? this.getCardNumUntilFour(this.getMatcher(Integer.parseInt(cardNum), matcher)).trim() : "";
    }

    private String getCardName(String cardName) {
        if (TextUtils.isEmpty((CharSequence)cardName)) {
            return "";
        }
        return cardName.replace("\uce74\ub4dc", "").replace("-", "");
    }

    private String getParsedData(String regStr, Matcher matcher) {
        StringBuilder valueStr = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)regStr)) {
            if (regStr.contains(",")) {
                String[] subMapping;
                for (String sub : subMapping = regStr.split(",")) {
                    if (TextUtils.isEmpty((CharSequence)sub)) continue;
                    valueStr.append(Validator.isNumber((String)sub) ? this.getMatcher(Integer.parseInt(sub), matcher) : sub);
                }
            } else {
                valueStr.append(Validator.isNumber((String)regStr) ? this.getMatcher(Integer.parseInt(regStr), matcher) : regStr);
            }
        }
        return valueStr.toString();
    }

    private String getMatcher(int pos, Matcher matcher) {
        try {
            return matcher.group(pos);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public void saveMigratedVersion(int version) {
        this.prefManager.saveIntValue("TENQUBE_VISUAL_MIGRATION_VERSION", version);
    }

    private String transformFullSMS(String fullSMS) {
        if (fullSMS == null) {
            fullSMS = "None";
        }
        fullSMS = fullSMS.replace("[FW]", "");
        fullSMS = fullSMS.replace("\u3000", " ");
        fullSMS = fullSMS.replace("\u21b5", " ");
        fullSMS = fullSMS.replace("FW>", "");
        fullSMS = fullSMS.replace("\ub4c0>", "");
        fullSMS = fullSMS.replace("[\uc7ac\uc804\uc1a1]", "");
        fullSMS = fullSMS.replace("[\ud22c]", "");
        fullSMS = fullSMS.replace("[Web\ubc1c\uc2e0]\n", "");
        fullSMS = fullSMS.replace("[Web\ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[Web \ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[web \ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[web\ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[WEB\ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("[WEB \ubc1c\uc2e0]", "");
        fullSMS = fullSMS.replace("(\uc7ac\uc804\uc1a1)", "");
        fullSMS = fullSMS.replace("[", " ");
        if ((fullSMS = fullSMS.replace("]", " ")).length() > 4 && fullSMS.substring(0, 4).contains("FW")) {
            fullSMS = fullSMS.replace("FW", "");
        }
        return fullSMS.replace("\n", " ");
    }
}

