/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.js.ConfirmBoxRequest;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.NewViewRequest;
import com.tenqube.visual_third.model.js.PageInfoRequest;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.VisualInterface;

public class UiImpl
extends Base
implements VisualInterface.UI,
BottomDialog.OnBottomListener {
    private String callbackSelectOrderBy;
    private final BottomDialog bottomDialog;

    public UiImpl(VisualWebActivity activity, WebView webView, VisualInterface.Error error, BottomDialog bottomDialog) {
        super(activity, webView, error);
        this.bottomDialog = bottomDialog;
        this.bottomDialog.setBottomListener(this);
    }

    @Override
    @JavascriptInterface
    public void openConfirmBox(String params) {
        String funcName = "openConfirmBox";
        try {
            final ConfirmBoxRequest confirmBoxRequest = Utils.fromJson(params, ConfirmBoxRequest.class);
            confirmBoxRequest.checkParams();
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
            builder.setMessage((CharSequence)confirmBoxRequest.getMessage());
            builder.setNegativeButton((CharSequence)confirmBoxRequest.getData().get(0).getButtonText(), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    UiImpl.this.callback(confirmBoxRequest.getData().get(0).getCallbackJS(), null);
                }
            });
            builder.setPositiveButton((CharSequence)confirmBoxRequest.getData().get(1).getButtonText(), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    UiImpl.this.callback(confirmBoxRequest.getData().get(1).getCallbackJS(), null);
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.show();
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void openSelectBox(String params) {
        String funcName = "openSelectBox";
        try {
            SelectBoxRequest selectBoxRequest = Utils.fromJson(params, SelectBoxRequest.class);
            selectBoxRequest.checkParams();
            this.callbackSelectOrderBy = selectBoxRequest.getDataCallbackJS();
            if (this.bottomDialog != null) {
                this.bottomDialog.showBottomDialog(selectBoxRequest);
            }
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    public void onItemSelected(SelectBoxInfo selectBoxInfo) {
        if (this.bottomDialog != null) {
            this.bottomDialog.dismiss();
        }
        this.callback(this.callbackSelectOrderBy, selectBoxInfo);
    }

    @Override
    @JavascriptInterface
    public void openNewView(String params) {
        String funcName = "openNewView";
        try {
            NewViewRequest newViewInfo = Utils.fromJson(params, NewViewRequest.class);
            newViewInfo.checkParams();
            if ("external".equals(newViewInfo.getViewType())) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)newViewInfo.getUrl()));
                this.activity.startActivity(i);
            } else if ("internal".equals(newViewInfo.getViewType())) {
                VisualWebActivity.startActivity((Context)this.activity, newViewInfo.getUrl());
            } else if ("google".equals(newViewInfo.getViewType())) {
                GoOpenMarketUtil.openOnGooglePlayMarket((Context)this.activity, newViewInfo.getUrl());
            }
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void finish(String path) {
        String funcName = "finish";
        try {
            if (this.activity != null) {
                if (!TextUtils.isEmpty((CharSequence)path)) {
                    Intent intent = this.activity.getIntent();
                    intent.putExtra("path", path);
                    this.activity.setResult(-1, intent);
                }
                this.activity.finish();
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void showSnackBar(String msg) {
        try {
            Snackbar.make((View)this.webView, (CharSequence)msg, (int)-1).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void showToast(String msg) {
        try {
            Toast.makeText((Context)this.activity, (CharSequence)msg, (int)0).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void onPageLoaded(String params) {
        try {
            PageInfoRequest page = Utils.fromJson(params, PageInfoRequest.class);
            page.checkParams();
            if (this.activity != null) {
                this.activity.onPagedLoaded();
            }
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void onScrollChanged(int pos) {
        try {
            if (this.activity != null) {
                this.activity.onScrollChanged(pos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void onFinish() {
        String funcName = "onFinish";
        try {
            this.callback("onFinish", null);
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void showDatePicker(String params) {
        String funcName = "showMonthPicker";
        try {
            DateRequest dateRequest = Utils.fromJson(params, DateRequest.class);
            dateRequest.checkParams();
            DatePickerFragment newFragment = DatePickerFragment.newInstance(dateRequest);
            newFragment.show(this.activity.getSupportFragmentManager(), "datePicker");
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void showTimePicker(String params) {
        String funcName = "showTimePicker";
        try {
            TimeRequest timeRequest = Utils.fromJson(params, TimeRequest.class);
            timeRequest.checkParams();
            TimePickerFragment newFragment = TimePickerFragment.newInstance(timeRequest);
            newFragment.show(this.activity.getSupportFragmentManager(), "timePicker");
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void reload() {
        String funcName = "reload";
        try {
            if (this.activity != null) {
                this.activity.reload();
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void retry() {
        String funcName = "retry";
        try {
            if (this.activity != null) {
                this.activity.retry();
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public void setRefreshEnabled(boolean enabled) {
        String funcName = "setRefreshEnabled";
        try {
            if (this.activity != null) {
                this.activity.setRefreshEnabled(enabled);
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.callbackWithStr(callback, date);
    }
}

