package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;

import java.util.ArrayList;

import static com.tenqube.visual_third.util.Utils.dpToPx;
import static com.tenqube.visual_third.util.Utils.getDeviceHeight;

public class BottomDialog {

    private static final int maxCnt = 6;
    private  OnBottomListener bottomListener;
    private final Activity activity;

    private BottomSheetDialog bottomSheetDialog;
    private int peekHeight;
    private int maxRecyclerHeight;
    private BottomAdapter adapter;
    public interface OnBottomListener {
        void onItemSelected(SelectBoxInfo selectBoxInfo);
    }

    public BottomDialog(Activity activity) {
        this.activity = activity;
    }

    public void setBottomListener(OnBottomListener bottomListener) {
        this.bottomListener = bottomListener;
        peekHeight = getDeviceHeight(activity) * 3/5 - dpToPx(24); // 60 %
        maxRecyclerHeight = dpToPx(52) * maxCnt - dpToPx(16);

    }

    public void showBottomDialog(SelectBoxRequest selectBoxRequest) {

        try {
            if(selectBoxRequest == null) return;

            if (bottomSheetDialog == null) {
                bottomSheetDialog = new BottomSheetDialog(activity);
                bottomSheetDialog.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
            }

            if (!isShowing()) {
                View view = activity.getLayoutInflater().inflate(R.layout.bottom_sheet_view, null);
                if (view != null) {

                    TextView titleTextView = (TextView) view.findViewById(R.id.title);
                    titleTextView.setText(selectBoxRequest.getTitle());

                    view.findViewById(R.id.close).setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            dismiss();
                        }
                    });

                    view.findViewById(R.id.enter).setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            if(bottomListener != null) bottomListener.onItemSelected(adapter.getItem());
                            dismiss();
                        }
                    });

                    RecyclerView recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);

                    if(selectBoxRequest.getData().size() > maxCnt) {
                        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
                        params.height = maxRecyclerHeight;
                        recyclerView.setLayoutParams(params);
                    }
                    final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(activity);
                    recyclerView.setLayoutManager(linearLayoutManager);
                    recyclerView.setHasFixedSize(true);
                    adapter = new BottomAdapter(selectBoxRequest);
                    recyclerView.setAdapter(adapter);

                    bottomSheetDialog.setContentView(view);

                    BottomSheetBehavior mBehavior = BottomSheetBehavior.from((View) view.getParent());
                    mBehavior.setPeekHeight(peekHeight);
                    bottomSheetDialog.show();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void dismiss() {
        if(isShowing()) {
            bottomSheetDialog.dismiss();
        }
    }

    private boolean isShowing() {
        return bottomSheetDialog != null && bottomSheetDialog.isShowing();
    }

    interface OnClickListener {
        void onClick(int position);
    }

    public static class BottomAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> implements  OnClickListener{


        private final ArrayList<SelectBoxInfo> selectBoxInfos;
        private int selectedPos = -1;

        BottomAdapter(SelectBoxRequest selectBoxRequests) {
            this.selectBoxInfos = selectBoxRequests.getData();
            setSelectedPos();
        }

        private void setSelectedPos() {

            int size = selectBoxInfos.size();
            for(int i = 0 ; i < size  ; i ++) {
                if(selectBoxInfos.get(i).isSelected()) {
                    selectedPos = i;
                    return;
                }
            }
        }

        public SelectBoxInfo getItem() {
            try {
                return selectBoxInfos.get(selectedPos);
            } catch (Exception e) {
                return null;
            }

        }

        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

            ViewGroup view = (ViewGroup) LayoutInflater.from(parent.getContext()).inflate(R.layout.adapter_select_box, parent, false);
            return new BottomViewHolder(view, this);
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

            try {
                SelectBoxInfo selectBoxInfo = selectBoxInfos.get(position);
                selectBoxInfo.setSelected(selectedPos == position);
                BottomViewHolder bHolder = (BottomViewHolder)holder;
                bHolder.onBind(selectBoxInfo);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public int getItemCount() {
            return selectBoxInfos == null ? 0 : selectBoxInfos.size();
        }

        @Override
        public void onClick(int position) {
            this.selectedPos = position;
            notifyDataSetChanged();

        }
    }

    static class BottomViewHolder extends RecyclerView.ViewHolder {

        RelativeLayout container;
        TextView nameTextView;
        ImageView imageView;

        BottomViewHolder(View convertView, final OnClickListener onClickListener) {
            super(convertView);

            convertView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if(onClickListener != null && getAdapterPosition() != RecyclerView.NO_POSITION) onClickListener.onClick(getAdapterPosition());
                }
            });

            container = (RelativeLayout) convertView.findViewById(R.id.container);
            nameTextView = (TextView) convertView.findViewById(R.id.name);
            imageView = (ImageView) convertView.findViewById(R.id.done);

        }

        void onBind(SelectBoxInfo selectBoxInfo) {

            imageView.setVisibility(selectBoxInfo.isSelected() ? View.VISIBLE : View.GONE);
            nameTextView.setText(selectBoxInfo.getName());
        }
    }
}
