package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.gt;
import static com.tenqube.visual_third.util.Validator.in;
import static com.tenqube.visual_third.util.Validator.isDate;
import static com.tenqube.visual_third.util.Validator.isStr;
import static com.tenqube.visual_third.util.Validator.isStrWithNull;
import static com.tenqube.visual_third.util.Validator.len;
import static com.tenqube.visual_third.util.Validator.lt;
import static com.tenqube.visual_third.util.Validator.notNull;
import static com.tenqube.visual_third.util.Validator.notZero;

public class AddPaymentRequest extends Request implements Serializable {


    private String name;

    private int type;

    private String callbackJS;


    public String getName() {
        return name;
    }

    public int getType() {
        return type;
    }

    public String getCallbackJS() {
        return callbackJS;
    }


    @Override
    public void checkParams() throws ParameterException {
        in(type, 0, 1, 2, 3);
        notNull(name);
        notNull(callbackJS);

    }
}
