package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.gt;
import static com.tenqube.visual_third.util.Validator.lt;
import static com.tenqube.visual_third.util.Validator.notNull;

public class SaveStartDayRequest extends Request implements Serializable {


    private int startDay;

    private String callbackJS;

    public int getStartDay() {
        return startDay;
    }

    public String getCallbackJS() {
        return callbackJS;
    }


    @Override
    public void checkParams() throws ParameterException {
        lt(startDay, 28);
        gt(startDay, 1);
        notNull(callbackJS);
    }
}
