/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.parser;

import android.text.TextUtils;
import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.parser.Transaction;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import java.io.Serializable;
import tenqube.parser.constants.Constants;

public class TransactionData
implements Serializable {
    private int tranId;
    private int cardId;
    private boolean isCredit;
    private String memo;
    private int dwType;
    private int largeIconResId;
    private String lCategory;
    private String mCategory;
    private String sCategory;
    private String categoryCode;
    private String keyword;
    private String address;
    private String companyTitle;
    private String spentDate;
    private String payment;
    private int installmentCount;
    private double amount;

    public TransactionData(int tranId, Transaction transaction, SearchCompanyResponse.TranCompany company, Category category) throws ParameterException {
        Validator.notNull(transaction);
        Validator.notNull(category);
        this.tranId = tranId;
        this.cardId = transaction.getCardId();
        this.keyword = transaction.getParsedTransaction().keyword;
        this.spentDate = transaction.getParsedTransaction().spentDate;
        this.amount = transaction.getParsedTransaction().spentMoney;
        this.installmentCount = transaction.getParsedTransaction().installmentCount;
        this.memo = transaction.getParsedTransaction().memo;
        this.dwType = transaction.getParsedTransaction().dwType;
        this.lCategory = category.getLarge();
        this.mCategory = category.getMedium();
        this.sCategory = category.getSmall();
        this.categoryCode = category.getCode() + "";
        this.largeIconResId = Utils.getCategoryIcon(Integer.parseInt(category.getLargeCode()));
        this.payment = transaction.getParsedTransaction().cardName;
        boolean bl = this.isCredit = transaction.getParsedTransaction().cardType == Constants.CardType.CARD.ordinal();
        if (!TextUtils.isEmpty((CharSequence)transaction.getParsedTransaction().cardNum)) {
            this.payment = this.payment + " " + transaction.getParsedTransaction().cardNum;
        }
        this.address = company.isPopUpCompanyName() ? company.getCompany().getAddress() : "";
        this.companyTitle = company.isPopUpCompanyName() ? company.getCompany().getName() : transaction.getParsedTransaction().keyword;
    }

    public boolean isCredit() {
        return this.isCredit;
    }

    public int getTranId() {
        return this.tranId;
    }

    public int getCardId() {
        return this.cardId;
    }

    public String getMemo() {
        return this.memo;
    }

    public int getDwType() {
        return this.dwType;
    }

    public int getLargeIconResId() {
        return this.largeIconResId;
    }

    public String getlCategory() {
        return this.lCategory;
    }

    public String getmCategory() {
        return this.mCategory;
    }

    public String getsCategory() {
        return this.sCategory;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getAddress() {
        return this.address;
    }

    public String getSpentDate() {
        return this.spentDate;
    }

    public String getPayment() {
        return this.payment;
    }

    public int getInstallmentCount() {
        return this.installmentCount;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getInstallmentStr() {
        return this.installmentCount == 1 || this.installmentCount == 0 ? "\uc77c\uc2dc\ubd88" : this.installmentCount + "\uac1c\uc6d4";
    }

    public String getSpentMoneyStr() {
        return Utils.threeComma(this.amount);
    }

    public String getCompanyTitle() {
        return this.companyTitle;
    }
}

