/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.catcher;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;
import com.tenqube.visual_third.util.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

public class MMSHelper {
    private Context mContext;

    MMSHelper(Context mContext) {
        this.mContext = mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMS getMMS() {
        try (Cursor mmsCursor = null;){
            Uri mmsUri = Uri.parse((String)"content://mms/inbox");
            mmsCursor = this.mContext.getContentResolver().query(mmsUri, null, "msg_box = 1", null, "_id desc limit 1");
            if (mmsCursor != null && mmsCursor.moveToFirst()) {
                int id2 = mmsCursor.getInt(mmsCursor.getColumnIndex("_id"));
                long date = mmsCursor.getLong(mmsCursor.getColumnIndex("date")) * 1000L;
                String tel = this.getMMSAddress(id2);
                String msg = this.parseMessage(id2 + "");
                SMS sMS = new SMS(id2, msg, tel, tel, Utils.getStringDateAsYYYYMMddHHmmss(this.convertDateLongToCalendar(date)), Constants.SMSType.MMS.ordinal());
                return sMS;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMMSAddress(int id2) {
        String address;
        block9: {
            String addrSelection = "msg_id=" + id2;
            Cursor cursor = null;
            address = "";
            String uriStr = "content://mms/" + id2 + "/addr";
            Uri uriAddress = Uri.parse((String)uriStr);
            String[] columns = new String[]{"address"};
            try {
                cursor = this.mContext.getContentResolver().query(uriAddress, columns, addrSelection, null, null);
                if (cursor == null || !cursor.moveToFirst()) break block9;
                do {
                    String val;
                    if ((val = cursor.getString(cursor.getColumnIndex("address"))) == null) continue;
                    address = val.replace("-", "");
                    break;
                } while (cursor.moveToNext());
            }
            catch (SQLiteException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseMessage(String id2) {
        Cursor cursor = null;
        String msg = null;
        Uri uri = Uri.parse((String)"content://mms/part");
        try {
            cursor = this.mContext.getContentResolver().query(uri, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    String mid = cursor.getString(cursor.getColumnIndex("mid"));
                    if (id2.equals(mid)) {
                        String partId = cursor.getString(cursor.getColumnIndex("_id"));
                        String type = cursor.getString(cursor.getColumnIndex("ct"));
                        if ("text/plain".equals(type)) {
                            String data = cursor.getString(cursor.getColumnIndex("_data"));
                            msg = data != null && !TextUtils.isEmpty((CharSequence)data) ? this.getMmsText(partId) : cursor.getString(cursor.getColumnIndex("text"));
                        }
                    }
                    cursor.moveToNext();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMmsText(String id2) {
        Uri partURI = Uri.parse((String)("content://mms/part/" + id2));
        InputStream is = null;
        StringBuilder sb = new StringBuilder();
        try {
            is = this.mContext.getContentResolver().openInputStream(partURI);
            if (is != null) {
                InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                BufferedReader reader = new BufferedReader(isr);
                String temp = reader.readLine();
                while (temp != null) {
                    sb.append(temp);
                    temp = reader.readLine();
                }
                isr.close();
                reader.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    private Calendar convertDateLongToCalendar(long date) {
        Calendar cal = Calendar.getInstance();
        if (date != 0L) {
            cal.setTimeInMillis(date);
        }
        return cal;
    }
}

