package com.tenqube.visual_third.model.analysis;

import static com.tenqube.visual_third.analysis.AnalysisHelper.getCnt;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getLv0Currency;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getNumber;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getNumberFirst;
import static com.tenqube.visual_third.analysis.AnalysisHelper.getPercent;
import static com.tenqube.visual_third.analysis.FunctionMap.CNT_UNIT;
import static com.tenqube.visual_third.analysis.FunctionMap.FIRSTDOT;
import static com.tenqube.visual_third.analysis.FunctionMap.LV0;
import static com.tenqube.visual_third.analysis.FunctionMap.NORMAL;
import static com.tenqube.visual_third.analysis.FunctionMap.PERCENT;

public class Result {

    private String displayValue;
    private String value;
    private double amount;

    public Result(String value) {
        this.value = value;
        this.displayValue = value;
    }

    public Result(String value, int type) {
        this.value = value;
        setDisplayValue(type);
    }

    public Result(double value, int type) {
        this.amount = value;
        this.value = "" + value;
        setDisplayValue(type);
    }

    public double getAmount() {
        return amount;
    }

    private void setDisplayValue(int type) {
        try {
            double value = Double.parseDouble(this.value);
            if(type == LV0) {
                this.displayValue = getLv0Currency(value);
            } else if (type == NORMAL) {
                this.displayValue = getNumber(value);
            } else if (type == FIRSTDOT) {
                this.displayValue = getNumberFirst(value);
            } else if (type == CNT_UNIT) {
                this.displayValue = getCnt(value, "회");
            } else if(type == PERCENT){
                this.displayValue = getPercent(value);
            } else {
                this.displayValue = "";
            }
        } catch (NumberFormatException e) {
            this.displayValue = "";
        }
    }

    /**
     * @return 보여질 값
     */
    public String getDisplayValue() {
        return displayValue;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return "Result{" +
                "displayValue='" + displayValue + '\'' +
                ", value='" + value + '\'' +
                ", amount=" + amount +
                '}';
    }
}
