/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.core;

import android.content.Context;
import com.google.gson.Gson;
import com.tenqube.visual_third.core.AddHeaderInterceptor;
import com.tenqube.visual_third.core.AuthorizationInterceptor;
import com.tenqube.visual_third.core.VisualApiService;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.SignUpInfo;
import com.tenqube.visual_third.model.TranCompany;
import com.tenqube.visual_third.model.VisualToken;
import com.tenqube.visual_third.model.VisualTransaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.model.Transaction;

class VisualApi {
    public static final String TAG = VisualApi.class.getSimpleName();
    public static VisualApi mInstance;
    private Context context;
    private VisualApiService visualApiService;
    private PrefManager prefManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualApi getInstance(Context context) {
        Class<VisualApi> clazz = VisualApi.class;
        synchronized (VisualApi.class) {
            if (mInstance == null) {
                mInstance = new VisualApi(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualApi(Context context) {
        this.context = context;
        this.prefManager = PrefManager.getInstance(context);
    }

    private VisualApiService getApiService() {
        if (this.visualApiService == null) {
            this.visualApiService = (VisualApiService)this.provideRetrofit("https://clip.tenqube.kr/dev/").create(VisualApiService.class);
        }
        return this.visualApiService;
    }

    private Retrofit provideRetrofit(String url) {
        return new Retrofit.Builder().baseUrl(url).client(this.provideOkHttpClient()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson())).build();
    }

    private OkHttpClient provideOkHttpClient() {
        OkHttpClient.Builder okhttpClientBuilder = new OkHttpClient.Builder();
        okhttpClientBuilder.connectTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.readTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.writeTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.addInterceptor((Interceptor)new AddHeaderInterceptor());
        okhttpClientBuilder.addInterceptor((Interceptor)new AuthorizationInterceptor(this.prefManager, this));
        return okhttpClientBuilder.build();
    }

    public void signUp(SignUpInfo signUpInfo) throws AuthException {
        try {
            VisualToken visualToken;
            Response response = this.getApiService().signUp(signUpInfo).execute();
            if (response.isSuccessful() && (visualToken = (VisualToken)response.body()) != null) {
                this.prefManager.saveStringValue("TENQUBE_ACCESS_TOKEN", visualToken.getAccessToken());
                this.prefManager.saveStringValue("TENQUBE_REFRESH_TOKEN", visualToken.getRefreshToken());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new AuthException("signUp error");
    }

    public void renewToken(String refreshToken) throws AuthException {
        try {
            VisualToken visualToken;
            Response response = this.getApiService().renewToken(refreshToken).execute();
            if (response.isSuccessful() && (visualToken = (VisualToken)response.body()) != null) {
                this.prefManager.saveStringValue("TENQUBE_ACCESS_TOKEN", visualToken.getAccessToken());
                this.prefManager.saveStringValue("TENQUBE_REFRESH_TOKEN", visualToken.getRefreshToken());
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new AuthException("RenewToken error");
    }

    public ParsingRule syncParsingRule() {
        try {
            Response response = this.getApiService().syncParsingRule(this.prefManager.loadIntValue("TENQUBE_PARSING_RULE_VERSION", -1)).execute();
            if (response.isSuccessful()) {
                ParsingRule parsingRule = (ParsingRule)response.body();
                if (parsingRule != null) {
                    this.prefManager.saveIntValue("TENQUBE_PARSING_RULE_VERSION", parsingRule.ruleVersion);
                }
                return (ParsingRule)response.body();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public TranCompany sendToServerTransactionsWithSync(ArrayList<Transaction> transactions) {
        try {
            Response response = this.getApiService().searchCompany(this.toVisualTransactions(transactions)).execute();
            if (response.isSuccessful()) {
                return (TranCompany)response.body();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void sendToServerTransactionsWithAsync(ArrayList<Transaction> transactions, Callback<TranCompany> callback) {
        Call<TranCompany> call = this.getApiService().searchCompany(this.toVisualTransactions(transactions));
        call.enqueue(callback);
    }

    private ArrayList<VisualTransaction> toVisualTransactions(ArrayList<Transaction> transactions) {
        ArrayList<VisualTransaction> visualTransactions = new ArrayList<VisualTransaction>();
        for (Transaction transaction : transactions) {
            if (transaction == null) continue;
            visualTransactions.add(new VisualTransaction(transaction));
        }
        return visualTransactions;
    }
}

