package com.tenqube.visual_third.model.js;

import android.text.TextUtils;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;

import java.io.Serializable;

public class AdRequest extends Request implements Serializable {

    private String where; // 2018-10-10

    private String callbackJS;

    public AdRequest(String where, String callbackJS) {
        this.where = where;
        this.callbackJS = callbackJS;
    }

    public String getWhere() {
        return TextUtils.isEmpty(where)? "all": where;
    }

    public String getCallbackJS() {
        return callbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        Validator.isStr(where, 100);
    }

}
