package com.tenqube.visual_third.manager;

import android.content.Context;

import com.crashlytics.android.Crashlytics;
import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.CustomEvent;
import com.tenqube.visual_third.model.js.LogRequest;

import java.util.ArrayList;

import io.fabric.sdk.android.Fabric;

public class AnswerManager {

    public static void onKeyMetric(LogRequest request) {

        String eventName = request.getEventName();
        ArrayList<LogRequest.Attribute> attributes = request.getAttributes();

        CustomEvent customEvent = new CustomEvent(eventName);

        if(attributes != null) {
            for(LogRequest.Attribute attribute : attributes) {
                customEvent.putCustomAttribute(attribute.getKey(), attribute.getValue());
            }
        }
        Answers.getInstance().logCustom(customEvent);
    }

    public static void initFabric(final Context context) {
        final Fabric fabric = new Fabric.Builder(context.getApplicationContext())
                .kits(new Crashlytics(), new Answers())
                .debuggable(true)
                .appIdentifier("com.tenqube.visual_third")
                .build();
        Fabric.with(fabric);

    }
}
