package com.tenqube.visual_third.entity;

import java.io.Serializable;

public class Category implements Serializable {

    private int id;
    private int code;
    private String large;
    private String medium;
    private String small;

    public Category(int id, int code, String large, String medium, String small) {
        this.id = id;
        this.code = code;
        this.large = large;
        this.medium = medium;
        this.small = small;
    }

    public String getInsertValue() {
        return "(" +
                id + "," +
                code + "," +
                "'" + large + "'," +
                "'" + medium + "'," +
                "'" + small + "')";
    }

    public int getId() {
        return id;
    }

    public int getCode() {
        return code;
    }

    public String getLarge() {
        return large;
    }

    public String getMedium() {
        return medium;
    }

    public String getSmall() {
        return small;
    }

    public String getLargeCode() {
        String code = this.code + "";
        return code.substring(0, 2);
    }

    public String getMediumCode() {

        String code = this.code + "";
        return code.substring(2, 4);

    }

    public String getLargeMediumCode() {

        String code = this.code + "";
        return code.substring(0, 4);

    }

    @Override
    public String toString() {
        return "Category{" +
                "id=" + id +
                ", code=" + code +
                ", large='" + large + '\'' +
                ", medium='" + medium + '\'' +
                ", small='" + small + '\'' +
                '}';
    }
}
