/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.text.TextUtils;
import com.mobon.sdk.MobonSDK;
import com.mobon.sdk.callback.iMobonAdCallback;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.R;
import java.io.Serializable;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobonManager {
    private static final String MEDIA_CODE = "hana";
    private static final String UNIT_ID = "42502";
    private final Context context;
    private final MobonSDK mobonSDK;

    public MobonManager(Context context) {
        this.context = context;
        this.mobonSDK = new MobonSDK(context.getApplicationContext(), MEDIA_CODE);
    }

    public void onImpression() {
        try {
            this.mobonSDK.onImpression();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAd(final Callback<AdItem> callback) {
        if (this.mobonSDK != null) {
            this.mobonSDK.setIMobonAdCallback(new iMobonAdCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onLoadedMobonAdData(boolean result, JSONObject objData, String errorStr) {
                    AdItem adItem = null;
                    try {
                        if (result) {
                            JSONObject jObj = objData.getJSONArray("client").getJSONObject(0);
                            JSONArray jArray = jObj.getJSONArray("data");
                            String mobonLogo = jObj.getString("mobonLogo");
                            if (jArray.length() > 0) {
                                adItem = new AdItem(mobonLogo, jArray.getJSONObject(0));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        callback.onDataLoaded(adItem);
                    }
                }
            });
            this.mobonSDK.getMobonAdData(this.context, 1, UNIT_ID);
        } else {
            callback.onDataLoaded(null);
        }
    }

    public class AdItem
    implements Serializable {
        public String imgUrl;
        public String title;
        public String desc;
        public String landingUrl;
        public String price;
        public int layout;
        public String viewKey;
        public String mobonLogo;

        public AdItem(String mobonLogo, JSONObject objData) throws Exception {
            this.viewKey = objData.optString("increaseViewKey");
            String pcode = objData.optString("pcode");
            this.mobonLogo = mobonLogo;
            if (TextUtils.isEmpty((CharSequence)pcode)) {
                this.title = objData.getString("pnm");
                this.desc = TextUtils.isEmpty((CharSequence)objData.getString("site_desc1")) ? objData.getString("desc") : objData.getString("site_desc1");
                this.title = objData.getString("pnm");
                this.price = "";
                String[] imgArray = new String[]{objData.optString("mimg_720_120"), objData.optString("mimg_728_90"), objData.optString("mimg_250_250"), objData.optString("img")};
                for (int i = 0; i < imgArray.length; ++i) {
                    String ext = imgArray[i].substring(imgArray[i].lastIndexOf(".") + 1);
                    if (!ext.equals("jpg") && !ext.equals("png") && !ext.equals("gif")) continue;
                    this.imgUrl = imgArray[i];
                    this.layout = i == 2 ? R.layout.mobon_view : R.layout.adlist_ad_item;
                    break;
                }
            } else {
                this.title = objData.getString("pnm");
                this.desc = objData.getString("site_desc1");
                this.price = objData.getString("price") + "\uc6d0";
                this.imgUrl = objData.getString("img");
                this.layout = R.layout.mobon_view;
            }
            this.landingUrl = objData.getString("purl");
            if (TextUtils.isEmpty((CharSequence)this.imgUrl)) {
                throw new Exception("img is null");
            }
        }
    }
}

