/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.manager;

import android.content.Context;
import android.text.TextUtils;
import com.tenqube.visual_third.entity.Currency;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;
import java.util.Calendar;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class CurrencyManager {
    private static final String TAG = CurrencyManager.class.getSimpleName();
    private static CurrencyManager mInstance = null;
    private VisualRepository repository;
    private Context mContext;
    public static final String TO_COUNTRY = "KRW";
    public static final String CURRENCY_FILE_NAME = "currency.tsv";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CurrencyManager getInstance(Context ctx) {
        Class<CurrencyManager> clazz = CurrencyManager.class;
        synchronized (CurrencyManager.class) {
            if (mInstance == null) {
                mInstance = new CurrencyManager(ctx.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private CurrencyManager(Context context) {
        this.mContext = context;
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
    }

    public double calculateSpentMoney(double spentMoney, String currency) {
        try {
            if ("none".equals(currency) || TextUtils.isEmpty((CharSequence)currency) || currency.length() != 3) {
                return spentMoney;
            }
            Currency currencyInfo = this.repository.loadCurrencyInfo(currency, TO_COUNTRY);
            if (currencyInfo == null) {
                return Utils.calculateCurrency(spentMoney, currency);
            }
            double rate = currencyInfo.getRate();
            boolean shouldServerCall = this.shouldServerCall(currencyInfo.getCreatedAt());
            if (shouldServerCall && (rate = this.repository.getCurrencyRate(currency, TO_COUNTRY, rate)) == 0.0) {
                rate = 1.0;
            }
            return spentMoney * rate;
        }
        catch (Exception e) {
            return Utils.calculateCurrency(spentMoney, currency);
        }
    }

    private boolean shouldServerCall(String createdAt) {
        Calendar todayCalendar = Calendar.getInstance();
        Calendar createdCalendar = Utils.convertStringToCalendarFULL(createdAt);
        todayCalendar.set(12, 0);
        todayCalendar.set(13, 0);
        createdCalendar.set(12, 0);
        createdCalendar.set(13, 0);
        int currentHour = todayCalendar.get(11);
        if (currentHour <= 8) {
            todayCalendar.add(5, -1);
            todayCalendar.set(11, 19);
        } else if (currentHour < 19) {
            todayCalendar.set(11, 9);
        } else {
            todayCalendar.set(11, 19);
        }
        LogUtil.LOGI((String)TAG, (String)("createCal" + createdAt), (boolean)ParserService.mIsDebug);
        LogUtil.LOGI((String)TAG, (String)("todayCal" + Utils.getStringDateAsYYYYMMddHHmmss(todayCalendar)), (boolean)ParserService.mIsDebug);
        return Utils.compareDate(createdCalendar, todayCalendar);
    }
}

