package com.tenqube.visual_third.manager;

import android.content.Context;
import android.text.TextUtils;

import com.tenqube.visual_third.entity.Currency;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;

import java.util.Calendar;

import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;


/**
 * Created by tenqube on 2018. 2. 13..
 */

public class CurrencyManager {
    private static final String TAG = CurrencyManager.class.getSimpleName();

    private static CurrencyManager mInstance = null;
    private VisualRepository repository;
    private Context mContext;

    public static final String TO_COUNTRY = "KRW";
    public static final String CURRENCY_FILE_NAME = "currency.tsv";

    public static CurrencyManager getInstance(Context ctx) {

        synchronized (CurrencyManager.class) {
            if (mInstance == null) {
                mInstance = new CurrencyManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    private CurrencyManager(Context context) {
        this.mContext = context;
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
    }

    /**
     *
     * @param spentMoney 파싱된 금액
     * @param currency 환율정보
     * @return 계산된 금액
     */
    public double calculateSpentMoney(double spentMoney, String currency) {
        try {
            if("none".equals(currency) || TextUtils.isEmpty(currency) || currency.length() != 3) return spentMoney;

            Currency currencyInfo = repository.loadCurrencyInfo(currency, TO_COUNTRY);
            if(currencyInfo == null) return Utils.calculateCurrency(spentMoney, currency);

            double rate = currencyInfo.getRate();
            boolean shouldServerCall = shouldServerCall(currencyInfo.getCreatedAt());

            if(shouldServerCall) {
                rate = repository.getCurrencyRate(currency, TO_COUNTRY, rate);
                if(rate == 0) rate = 1;
            }
            return spentMoney * rate;
        } catch (Exception e) {
            //예외시 로컬 사용
            return Utils.calculateCurrency(spentMoney, currency);
        }
    }

    /**
     * @param createdAt
     * @return
     */
    private boolean shouldServerCall(String createdAt) {
        Calendar todayCalendar = Calendar.getInstance();
        Calendar createdCalendar = Utils.convertStringToCalendarFULL(createdAt);

        todayCalendar.set(Calendar.MINUTE , 0);
        todayCalendar.set(Calendar.SECOND , 0);

        createdCalendar.set(Calendar.MINUTE , 0);
        createdCalendar.set(Calendar.SECOND , 0);

        int currentHour = todayCalendar.get(Calendar.HOUR_OF_DAY);
        // today 2018-02-13 10:22:22
        // 2018-02-13 01:22:22 createDate

        if (currentHour <= 8) {
            todayCalendar.add(Calendar.DATE, -1);
            todayCalendar.set(Calendar.HOUR_OF_DAY, 19);
        } else if(currentHour < 19) {
            todayCalendar.set(Calendar.HOUR_OF_DAY, 9);
        } else {
            todayCalendar.set(Calendar.HOUR_OF_DAY, 19);
        }

        LOGI(TAG, "createCal" + createdAt, mIsDebug);
        LOGI(TAG, "todayCal" + Utils.getStringDateAsYYYYMMddHHmmss(todayCalendar), mIsDebug);


        return Utils.compareDate(createdCalendar, todayCalendar);

    }

}
