package com.tenqube.visual_third.api.resource;

import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.VersionResponse;

import java.io.IOException;

import retrofit2.Response;
import tenqube.parser.model.ParsingRule;

public class ResourceServiceImpl implements ResourceService {

    private static final String TAG = ResourceServiceImpl.class.getSimpleName();

    private final ResourceApi resourceApi;

    private ResourceServiceImpl(ResourceApi resourceApi) {

        this.resourceApi = resourceApi;
    }

    private static ResourceService mInstance;

    public static ResourceService getInstance(ResourceApi resourceApi) {
        synchronized (ResourceServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new ResourceServiceImpl(resourceApi);
            }
        }
        return mInstance;
    }

    @Override
    public VersionResponse syncVersion() {
        try {
            Response<VersionResponse> response = resourceApi.syncVersion().execute();
            if (response != null) {
                if (response.isSuccessful()) {
                    return response.body();
                }
            }

        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;

    }

    @Override
    public SyncCategoryResponse syncCategory(int clientVersion, int serverVersion) {
        if(serverVersion > clientVersion) {

            try {
                Response<SyncCategoryResponse> response = resourceApi.syncCategory(ResourceApi.CATEGORY,
                        clientVersion,
                        serverVersion).execute();

                if (response.isSuccessful()) {

                    return response.body();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        return null;
    }

    @Override
    public NotificationPkgResponse syncNotificationApps() {

        try {
            Response<NotificationPkgResponse> response = resourceApi.syncNotificationApps().execute();

            if (response.isSuccessful()) {

                return response.body();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;

    }

    @Override
    public AnalysisResponse syncAnalysis(int clientVersion, int serverVersion) {
        if(serverVersion > clientVersion) {

            try {
                Response<AnalysisResponse> response = resourceApi.syncAnalysis(ResourceApi.ANALYSIS,
                        clientVersion,
                        serverVersion).execute();

                if (response.isSuccessful()) {

                    return response.body();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

        }

        return null;
    }

    @Override
    public NotificationResponse syncNotification() {
        try {
            Response<NotificationResponse> response = resourceApi.syncNotification().execute();

            if (response.isSuccessful()) {

                return response.body();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }

    @Override
    public ParsingRule syncParsingRule(int clientVersion, int serverVersion) {
        try {
            if(serverVersion > clientVersion) {
                Response<ParsingRule> ruleResponse = resourceApi.syncParsingRule(
                        ResourceApi.PARSING_RULE,
                        clientVersion,
                        serverVersion).execute();

                if(ruleResponse.isSuccessful()) {
                    return ruleResponse.body();
                }
            }

        } catch (IOException e) {
            e.printStackTrace();
        }

        return null;
    }

    @Override
    public ParsingRuleKey syncParsingRuleKey() {

        try {
            Response<ParsingRuleKey> response = resourceApi.syncParsingRuleKey().execute();
            if (response != null) {
                if (response.isSuccessful()) {
                    return response.body();
                }
            }

        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

}
