/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.text.TextUtils;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.SenderTransaction;
import java.util.ArrayList;
import java.util.List;

public class SenderTransactionDao {
    private final Db db;

    public SenderTransactionDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SenderTransaction> loadSendersByIdentifiers(List<String> ids) {
        if (ids.isEmpty()) {
            return new ArrayList<SenderTransaction>();
        }
        String query = QueryGenerator.senderTransactionByIds(ids);
        ArrayList<SenderTransaction> results = new ArrayList<SenderTransaction>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.SenderTransactionTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    public int insert(String sender, String identifier) {
        try {
            if (TextUtils.isEmpty((CharSequence)sender) || TextUtils.isEmpty((CharSequence)identifier)) {
                return 0;
            }
            ContentValues values = new ContentValues();
            values.put("sender", sender);
            values.put("tran_identifier", identifier);
            values.put("created_at", Long.valueOf(System.currentTimeMillis()));
            return (int)this.db.insert(" SENDER_TRANSACTIONS ", values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void deleteAll() {
        try {
            this.db.delete(" SENDER_TRANSACTIONS ", null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

