/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.js.Cards;
import com.tenqube.visual_third.model.js.CategoryInfo;
import com.tenqube.visual_third.model.js.DeleteTranRequest;
import com.tenqube.visual_third.model.js.InsertTransactionRequest;
import com.tenqube.visual_third.model.js.Lv0Info;
import com.tenqube.visual_third.model.js.SettingNotiRequest;
import com.tenqube.visual_third.model.js.SettingNotiResponse;
import com.tenqube.visual_third.model.js.Success;
import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.js.Transactions;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.VisualInterface;
import java.util.ArrayList;
import java.util.Calendar;
import tenqube.parser.constants.Constants;

public class RepoImpl
extends Base
implements VisualInterface.Repo {
    private final VisualRepository repository;
    private final VisualApi api;
    private final AnalysisService analysisService;
    private final VisualAlarmManager alarmManager;

    public RepoImpl(VisualWebActivity activity, WebView webView, VisualInterface.Error error, VisualRepository repository, VisualApi api, AnalysisService service, VisualAlarmManager alarmManager) {
        super(activity, webView, error);
        this.repository = repository;
        this.api = api;
        this.analysisService = service;
        this.alarmManager = alarmManager;
    }

    @Override
    @JavascriptInterface
    public void deleteTransactions(String params) {
        String funcName = "deleteTransactions";
        DeleteTranRequest deleteTranRequest = null;
        try {
            deleteTranRequest = Utils.fromJson(params, DeleteTranRequest.class);
            deleteTranRequest.checkParams();
            this.repository.updateDeletedTransactionById(deleteTranRequest.getIds());
            this.api.syncTransactions(null);
            LocalBroadcastManager.getInstance((Context)this.activity).sendBroadcast(new Intent("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED"));
            this.callback(deleteTranRequest.getCallbackJS(), new Success(true));
        }
        catch (Exception e) {
            if (deleteTranRequest != null) {
                this.callback(deleteTranRequest.getCallbackJS(), new Success(false));
            }
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void getCategories(final String callback) {
        String funcName = "getCategories";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    ArrayList<CategoryInfo.ServerCategory> serverCategories = RepoImpl.this.repository.loadCategories();
                    ArrayList<CategoryInfo.UserCategory> userCategories = RepoImpl.this.repository.loadUserCategories();
                    CategoryInfo categoryInfo = new CategoryInfo(serverCategories, userCategories);
                    RepoImpl.this.callback(callback, categoryInfo);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getCategories", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getCategories", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getCards(final String callback) {
        String funcName = "getCards";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    ArrayList<Cards.Card> cardList = RepoImpl.this.repository.loadCards();
                    Cards cards = new Cards(cardList);
                    RepoImpl.this.callback(callback, cards);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getCards", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getCards", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getTransactions(final String params) {
        String funcName = "getTransactions";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionRequest transactionRequest = Utils.fromJson(params, TransactionRequest.class);
                    transactionRequest.checkParams();
                    transactionRequest.setDwType(-1);
                    transactionRequest.setExceptType(-1);
                    ArrayList<Transactions.Transaction> tranList = RepoImpl.this.repository.loadTransactions(transactionRequest);
                    Transactions transactions = new Transactions(tranList);
                    RepoImpl.this.callback(transactionRequest.getCallbackJS(), transactions);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getTransactions", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getTransactions", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getTransactionsByIds(final String params) {
        String funcName = "getTransactionsByIds";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionByIdsRequest transactionRequest = Utils.fromJson(params, TransactionByIdsRequest.class);
                    transactionRequest.checkParams();
                    ArrayList<Transactions.Transaction> tranList = RepoImpl.this.repository.loadTransactions(transactionRequest);
                    Transactions transactions = new Transactions(tranList);
                    RepoImpl.this.callback(transactionRequest.getCallbackJS(), transactions);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getTransactionsByIds", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getTransactionsByIds", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getLv0Contents(final String callback) {
        String funcName = "getLv0Contents";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    Calendar calendar = Calendar.getInstance();
                    int year = calendar.get(1);
                    int month = calendar.get(2) + 1;
                    TransactionRequest request = new TransactionRequest(year, month, 3, "");
                    request.setDwType(Constants.DWType.WITHDRAW.ordinal());
                    request.setExceptType(0);
                    ArrayList<Transaction> transactions = RepoImpl.this.repository.loadAnalysisTransactions(request);
                    if (!Utils.isEmpty(transactions)) {
                        ArrayList<Analysis> analyses = RepoImpl.this.analysisService.loadAnalysisList(transactions);
                        ArrayList<Lv0Info.Lv0> lv0s = Mapper.toLv0s(analyses);
                        Lv0Info lv0Info = new Lv0Info(lv0s);
                        RepoImpl.this.callback(callback, lv0Info);
                    }
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getLv0Contents", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getLv0Contents", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void insertTransaction(final String params) {
        String funcName = "insertTransaction";
        new Thread(new Runnable(){

            @Override
            public void run() {
                InsertTransactionRequest insertTransactionRequest = null;
                try {
                    insertTransactionRequest = Utils.fromJson(params, InsertTransactionRequest.class);
                    insertTransactionRequest.checkParams();
                    int id2 = RepoImpl.this.repository.insertTransaction(insertTransactionRequest);
                    if (id2 == 0) {
                        RepoImpl.this.callback(insertTransactionRequest.getCallbackJS(), new Success(false));
                        return;
                    }
                    insertTransactionRequest.setTranId(id2);
                    JoinedTransaction joinedTransaction = RepoImpl.this.repository.loadJoinedTransaction(insertTransactionRequest.getTranId());
                    SearchCompanyRequest.Transaction transaction = new SearchCompanyRequest.Transaction(joinedTransaction);
                    transaction.setlCode(insertTransactionRequest.getlCode());
                    transaction.setmCode(insertTransactionRequest.getmCode());
                    ArrayList<SearchCompanyRequest.Transaction> transactions = new ArrayList<SearchCompanyRequest.Transaction>();
                    transactions.add(transaction);
                    SearchCompanyResponse response = RepoImpl.this.api.searchCompany(new SearchCompanyRequest(transactions));
                    if (response != null && response.getResults().size() > 0) {
                        RepoImpl.this.repository.updateTransaction(response.getResults().get(0), false);
                        RepoImpl.this.api.syncTransactions(null);
                    }
                    RepoImpl.this.callback(insertTransactionRequest.getCallbackJS(), new Success(true));
                    LocalBroadcastManager.getInstance((Context)RepoImpl.this.activity).sendBroadcast(new Intent("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED"));
                }
                catch (ParameterException e) {
                    RepoImpl.this.callback(insertTransactionRequest.getCallbackJS(), new Success(false));
                    RepoImpl.this.onError("insertTransaction", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("insertTransaction", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void updateTransaction(final String params) {
        String funcName = "updateTransaction";
        new Thread(new Runnable(){

            @Override
            public void run() {
                UpdateTransactionRequest updateTransactionRequest = null;
                try {
                    updateTransactionRequest = Utils.fromJson(params, UpdateTransactionRequest.class);
                    updateTransactionRequest.checkParams();
                    RepoImpl.this.repository.updateTransaction(updateTransactionRequest);
                    JoinedTransaction joinedTransaction = RepoImpl.this.repository.loadJoinedTransaction(updateTransactionRequest.getTranId());
                    SearchCompanyRequest.Transaction transaction = new SearchCompanyRequest.Transaction(joinedTransaction);
                    transaction.setlCode(updateTransactionRequest.getlCode());
                    transaction.setmCode(updateTransactionRequest.getmCode());
                    ArrayList<SearchCompanyRequest.Transaction> transactions = new ArrayList<SearchCompanyRequest.Transaction>();
                    transactions.add(transaction);
                    SearchCompanyResponse response = RepoImpl.this.api.searchCompany(new SearchCompanyRequest(transactions));
                    if (response != null && response.getResults().size() > 0) {
                        RepoImpl.this.repository.updateTransaction(response.getResults().get(0), updateTransactionRequest.isAll());
                        RepoImpl.this.api.syncTransactions(null);
                    }
                    RepoImpl.this.callback(updateTransactionRequest.getCallbackJS(), new Success(true));
                    LocalBroadcastManager.getInstance((Context)RepoImpl.this.activity).sendBroadcast(new Intent("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED"));
                }
                catch (ParameterException e) {
                    RepoImpl.this.callback(updateTransactionRequest.getCallbackJS(), new Success(false));
                    RepoImpl.this.onError("updateTransaction", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("updateTransaction", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public boolean shouldShowTranPopup() {
        return this.repository.shouldShowTranPopup();
    }

    @Override
    @JavascriptInterface
    public void setTranPopup(boolean shouldShow) {
        this.repository.setTranPopup(shouldShow);
    }

    @Override
    @JavascriptInterface
    public void settingNotification(final String params) {
        String funcName = "settingNotification";
        new Thread(new Runnable(){

            @Override
            public void run() {
                SettingNotiRequest settingNotiRequest = null;
                try {
                    settingNotiRequest = Utils.fromJson(params, SettingNotiRequest.class);
                    settingNotiRequest.checkParams();
                    RepoImpl.this.repository.setActiveNoti(settingNotiRequest.getName().contains("weekly") ? "weekly" : settingNotiRequest.getName(), settingNotiRequest.isEnabled());
                    if (settingNotiRequest.getHour() != null) {
                        RepoImpl.this.repository.updateNotiHour(settingNotiRequest.getName(), settingNotiRequest.getHour());
                    }
                    RepoImpl.this.alarmManager.setAlarms();
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("settingNotification", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("settingNotification", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getNotificationSettings(final String callback) {
        String funcName = "getNotificationSettings";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.notNull(callback);
                    ArrayList<VisualNotification> notifications = RepoImpl.this.repository.loadNotifications();
                    if (Utils.isEmpty(notifications)) {
                        throw new ParameterException("empty");
                    }
                    ArrayList<SettingNotiRequest> settings = new ArrayList<SettingNotiRequest>();
                    for (VisualNotification notification : notifications) {
                        settings.add(new SettingNotiRequest(notification.getName(), notification.isEnable(), notification.getHour()));
                    }
                    SettingNotiResponse res = new SettingNotiResponse(settings);
                    RepoImpl.this.callback(callback, res);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getNotificationSettings", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getNotificationSettings", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void initialize(final String callback) {
        String funcName = "initialize";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.notNull(callback);
                    RepoImpl.this.repository.deleteCard();
                    RepoImpl.this.repository.deleteTransactions();
                    RepoImpl.this.repository.insertCash();
                    RepoImpl.this.callback(callback, new Success(true));
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("initialize", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("initialize", e.toString());
                }
            }
        }).start();
    }
}

