package com.tenqube.visual_third.model.api;

import com.google.gson.annotations.SerializedName;
import com.tenqube.visual_third.exception.ParameterException;

import static com.tenqube.visual_third.util.Validator.isStr;

public class SignUpRequest {

    @SerializedName("uid")
    private final String custId;

    public SignUpRequest(String custId) throws ParameterException {
        isStr(custId, 500);
        this.custId = custId;
    }

    public String getCustId() {
        return custId;
    }
}
