/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.manager.CurrencyManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.parser.Transaction;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.ResourceRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParsingRule;

class BaseLoader {
    final Context mContext;
    ParserService parserService;
    PrefManager prefManager;
    VisualRepository repository;
    ResourceRepository resourceRepository;
    private CurrencyManager currencyManager;

    BaseLoader(Context context) {
        this.mContext = context;
        this.parserService = ParserService.getInstance((Context)context);
        this.parserService.setDebugMode(true);
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
        this.resourceRepository = RepositoryHolder.getInstance(context).getResourceRepository();
        this.prefManager = PrefManager.getInstance(context);
        this.currencyManager = CurrencyManager.getInstance(context);
        this.syncParsingRuleKey();
    }

    private void syncParsingRuleKey() {
        try {
            ParsingRuleKey parsingRuleKey;
            if (!this.prefManager.isEnabled("TENQUBE_PARSING_RULE_KEY", false) && (parsingRuleKey = this.resourceRepository.syncParsingRuleKey()) != null) {
                ParsingRule parsingRule = new ParsingRule(parsingRuleKey.getSecurityKey(), parsingRuleKey.getTranCount(), 214, new ArrayList(), new ArrayList(), new ArrayList());
                this.parserService.syncParsingRule(parsingRule);
                this.prefManager.saveBoolean("TENQUBE_PARSING_RULE_KEY", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void syncParsingRule(final Callback<Boolean> callback) {
        this.resourceRepository.syncParsingRule(new Callback<ParsingRule>(){

            @Override
            public void onDataLoaded(ParsingRule parsingRule) {
                if (parsingRule != null) {
                    BaseLoader.this.parserService.syncParsingRule(parsingRule);
                    BaseLoader.this.prefManager.saveIntValue("TENQUBE_PARSING_RULE_VERSION", parsingRule.ruleVersion);
                }
                if (callback != null) {
                    callback.onDataLoaded(true);
                }
            }
        });
    }

    void setCurrency(ArrayList<Transaction> transactions) {
        for (Transaction parsedTran : transactions) {
            parsedTran.setSpentMoney(this.currencyManager.calculateSpentMoney(parsedTran.getParsedTransaction().spentMoney, parsedTran.getParsedTransaction().currency));
        }
    }
}

