/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.search;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.tenqube.visual_third.api.search.SearchApi;
import com.tenqube.visual_third.api.search.SearchService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import retrofit2.Response;

public class SearchServiceImpl
implements SearchService {
    private final SearchApi searchApi;
    private final PrefManager prefManager;
    private final Context context;
    private static SearchService mInstance;

    private SearchServiceImpl(Context context, SearchApi searchApi, PrefManager prefManager) {
        this.context = context;
        this.searchApi = searchApi;
        this.prefManager = prefManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchService getInstance(Context context, SearchApi searchApi, PrefManager prefManager) {
        Class<SearchServiceImpl> clazz = SearchServiceImpl.class;
        synchronized (SearchServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new SearchServiceImpl(context, searchApi, prefManager);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public SearchCompanyResponse searchCompany(@NonNull SearchCompanyRequest searchCompanyRequest) {
        try {
            String url = this.prefManager.loadStringValue("TENQUBE_SEARCH_URL", "");
            if (TextUtils.isEmpty((CharSequence)url)) {
                return null;
            }
            Response response = this.searchApi.searchCompany(url, searchCompanyRequest).execute();
            if (response.isSuccessful()) {
                return (SearchCompanyResponse)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

