/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Validator;
import tenqube.parser.core.ParserService;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private Context context;
    private ParserService parserService;
    private VisualRepository repository;
    private VisualAlarmManager alarmManager;

    public VisualServiceImpl(@NonNull Context context, @NonNull String apiKey, @NonNull String qualifier, @NonNull String authority) throws ParameterException {
        Validator.notNull(context);
        Validator.isNotEmpty(apiKey);
        Validator.isNotEmpty(authority);
        Validator.in(qualifier, "dev", "prod");
        this.context = context;
        this.repository = RepositoryHolder.getInstance(context).getVisualRepository();
        this.repository.saveSDKInfo(apiKey, qualifier, authority);
        this.parserService = ParserService.getInstance((Context)context);
        this.alarmManager = VisualAlarmManager.getInstance(context);
        AnswerManager.initFabric(context);
    }

    @Override
    public void startVisual(final @Nullable Activity activity, @NonNull String uid, final @Nullable String path, final @NonNull OnResultListener resultListener) throws ParameterException {
        Validator.isNotEmpty(uid);
        Validator.notNull(resultListener);
        this.repository.signUp(uid, new OnResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onResult(int signUpResult, String msg) {
                try {
                    switch (signUpResult) {
                        case 0: 
                        case 2: {
                            AnswerManager.onKeyMetric(new LogRequest("startVisual"));
                            if (activity == null) {
                                VisualWebActivity.startActivity(VisualServiceImpl.this.context, path);
                                return;
                            }
                            VisualWebActivity.startActivity(activity, path);
                            return;
                        }
                    }
                    return;
                }
                catch (AuthException e) {
                    signUpResult = 1;
                    msg = e.toString();
                    return;
                }
                finally {
                    resultListener.onResult(signUpResult, msg);
                }
            }
        });
    }

    @Override
    public void signOut(Callback callback) {
        this.repository.signOut(callback);
    }

    @Override
    public void settingNotification(int smallIcon, @NonNull String channel, int color2) throws ParameterException {
        Validator.notZero(smallIcon);
        Validator.notNull(channel);
        this.repository.settingNotification(smallIcon, channel, color2);
    }

    @Override
    public boolean isActiveTranPopup() {
        AnswerManager.onKeyMetric(new LogRequest("isActiveTranPopup"));
        return this.repository.shouldShowTranPopup();
    }

    @Override
    public void setTranPopup(boolean isActive) {
        AnswerManager.onKeyMetric(new LogRequest("setTranPopup"));
        this.repository.setTranPopup(isActive);
    }

    @Override
    public void setReportAlarm(Constants.ReportAlarmType type, boolean isActive) {
        this.repository.setActiveNoti(type.name().toLowerCase(), isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveReportAlarm(Constants.ReportAlarmType type) {
        return this.repository.isActiveNoti(type.name().toLowerCase());
    }

    @Override
    public void setReportTest(Constants.ReportAlarmType type, int second) {
        VisualAlarmManager.getInstance(this.context).setReportTest(type.name().toLowerCase(), second);
    }

    @Override
    public void setLogger(boolean isActive) {
        if (this.isActive() && this.parserService != null) {
            this.parserService.setDebugMode(isActive);
        }
    }

    @Override
    public void initSDK() {
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.repository.setEnabled(enabled);
        if (!enabled) {
            this.repository.setActiveNoti(Constants.ReportAlarmType.MONTHLY.name().toLowerCase(), false);
            this.repository.setActiveNoti(Constants.ReportAlarmType.WEEKLY.name().toLowerCase(), false);
            this.repository.setActiveNoti(Constants.ReportAlarmType.DAILY.name().toLowerCase(), false);
        }
        this.alarmManager.setAlarms();
    }

    @Override
    public void setAppNoti(boolean isActive) {
        this.repository.setAppNoti(isActive);
        this.alarmManager.setAlarms();
    }

    @Override
    public boolean isActiveAppNoti() {
        return this.repository.isAppNoti();
    }

    private boolean isActive() {
        return this.context != null;
    }
}

