package com.tenqube.visual_third.api.search;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;

import retrofit2.Response;

public class SearchServiceImpl implements SearchService {

    private final SearchApi searchApi;
    private final PrefManager prefManager;
    private final Context context;

    private SearchServiceImpl(Context context, SearchApi searchApi, PrefManager prefManager) {
        this.context = context;
        this.searchApi = searchApi;
        this.prefManager = prefManager;
    }

    private static SearchService mInstance;

    public static SearchService getInstance(Context context, SearchApi searchApi, PrefManager prefManager) {
        synchronized (SearchServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new SearchServiceImpl(context, searchApi, prefManager);
            }
        }
        return mInstance;
    }

    public SearchCompanyResponse searchCompany(@NonNull SearchCompanyRequest searchCompanyRequest) {
        try {
            String url = prefManager.loadStringValue(PrefManager.SEARCH_URL, "");
            if(TextUtils.isEmpty(url))
                return null;

            Response<SearchCompanyResponse> response = searchApi.searchCompany(url, searchCompanyRequest).execute();

            if(response.isSuccessful()) {
                return response.body();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }
}
