package com.tenqube.visual_third.api.resource;

import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.VersionResponse;

import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Query;
import tenqube.parser.model.ParsingRule;

public interface ResourceApi {

    String CATEGORY = "category";
    String ANALYSIS = "analysis";
    String PARSING_RULE = "parsingRule";

    @GET("resource/version")
    Call<VersionResponse> syncVersion();

    @GET("resource")
    Call<SyncCategoryResponse> syncCategory(@Query("type") String type,
                                            @Query("clientVersion") int clientVersion,
                                            @Query("serverVersion") int serverVersion);

    @GET("resource")
    Call<ParsingRule> syncParsingRule(@Query("type") String type,
                                      @Query("clientVersion") int clientVersion,
                                      @Query("serverVersion") int serverVersion);

    @GET("resource/notification-apps")
    Call<NotificationPkgResponse> syncNotificationApps();


    @GET("resource/parsing-rule/key")
    Call<ParsingRuleKey> syncParsingRuleKey();

    @GET("resource")
    Call<AnalysisResponse> syncAnalysis(@Query("type") String type,
                                        @Query("clientVersion") int clientVersion,
                                        @Query("serverVersion") int serverVersion);

    @GET("resource/notification")
    Call<NotificationResponse> syncNotification();

}
