/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.model.api.AdResponse;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.js.AdRequest;
import com.tenqube.visual_third.model.js.Cards;
import com.tenqube.visual_third.model.js.CategoryInfo;
import com.tenqube.visual_third.model.js.Lv0Info;
import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.model.js.Transactions;
import com.tenqube.visual_third.model.js.UpdateTransactionRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.Validator;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.VisualInterface;
import java.util.ArrayList;
import java.util.Calendar;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import tenqube.parser.constants.Constants;

public class RepoImpl
extends Base
implements VisualInterface.Repo {
    private final VisualRepository repository;
    private final VisualApi api;
    private final AnalysisService analysisService;

    public RepoImpl(VisualWebActivity activity, WebView webView, VisualInterface.Error error, VisualRepository repository, VisualApi api, AnalysisService service) {
        super(activity, webView, error);
        this.repository = repository;
        this.api = api;
        this.analysisService = service;
    }

    @Override
    @JavascriptInterface
    public void getAds(String params) {
        String funcName = "getAds";
        try {
            final AdRequest adRequest = Utils.fromJson(params, AdRequest.class);
            this.api.getAds(adRequest, new Callback<AdResponse>(){

                public void onResponse(Call<AdResponse> call, Response<AdResponse> response) {
                    if (response.isSuccessful()) {
                        RepoImpl.this.callback(adRequest.getCallbackJS(), response.body());
                    } else {
                        RepoImpl.this.callback(adRequest.getCallbackJS(), "");
                    }
                }

                public void onFailure(Call<AdResponse> call, Throwable t) {
                    RepoImpl.this.callback(adRequest.getCallbackJS(), "");
                }
            });
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void getCategories(final String callback) {
        String funcName = "getCategories";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    ArrayList<CategoryInfo.ServerCategory> serverCategories = RepoImpl.this.repository.loadCategories();
                    ArrayList<CategoryInfo.UserCategory> userCategories = RepoImpl.this.repository.loadUserCategories();
                    CategoryInfo categoryInfo = new CategoryInfo(serverCategories, userCategories);
                    RepoImpl.this.callback(callback, categoryInfo);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getCategories", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getCategories", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getCards(final String callback) {
        String funcName = "getCards";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    ArrayList<Cards.Card> cardList = RepoImpl.this.repository.loadCards();
                    Cards cards = new Cards(cardList);
                    RepoImpl.this.callback(callback, cards);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getCards", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getCards", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getTransactions(final String params) {
        String funcName = "getTransactions";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionRequest transactionRequest = Utils.fromJson(params, TransactionRequest.class);
                    transactionRequest.checkParams();
                    transactionRequest.setDwType(-1);
                    transactionRequest.setExceptType(-1);
                    ArrayList<Transactions.Transaction> tranList = RepoImpl.this.repository.loadTransactions(transactionRequest);
                    Transactions transactions = new Transactions(tranList);
                    RepoImpl.this.callback(transactionRequest.getCallbackJS(), transactions);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getTransactions", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getTransactions", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getTransactionsByIds(final String params) {
        String funcName = "getTransactionsByIds";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TransactionByIdsRequest transactionRequest = Utils.fromJson(params, TransactionByIdsRequest.class);
                    transactionRequest.checkParams();
                    ArrayList<Transactions.Transaction> tranList = RepoImpl.this.repository.loadTransactions(transactionRequest);
                    Transactions transactions = new Transactions(tranList);
                    RepoImpl.this.callback(transactionRequest.getCallbackJS(), transactions);
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getTransactionsByIds", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getTransactionsByIds", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void getLv0Contents(final String callback) {
        String funcName = "getLv0Contents";
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Validator.isStr(callback, 100);
                    Calendar calendar = Calendar.getInstance();
                    int year = calendar.get(1);
                    int month = calendar.get(2) + 1;
                    TransactionRequest request = new TransactionRequest(year, month, 3, "");
                    request.setDwType(Constants.DWType.WITHDRAW.ordinal());
                    request.setExceptType(0);
                    ArrayList<Transaction> transactions = RepoImpl.this.repository.loadAnalysisTransactions(request);
                    if (!Utils.isEmpty(transactions)) {
                        ArrayList<Analysis> analyses = RepoImpl.this.analysisService.loadAnalysisList(transactions);
                        ArrayList<Lv0Info.Lv0> lv0s = Mapper.toLv0s(analyses);
                        Lv0Info lv0Info = new Lv0Info(lv0s);
                        RepoImpl.this.callback(callback, lv0Info);
                    }
                }
                catch (ParameterException e) {
                    RepoImpl.this.onError("getLv0Contents", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("getLv0Contents", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public void updateTransaction(final String params) {
        String funcName = "updateTransaction";
        new Thread(new Runnable(){

            @Override
            public void run() {
                UpdateTransactionRequest updateTransactionRequest = null;
                try {
                    updateTransactionRequest = Utils.fromJson(params, UpdateTransactionRequest.class);
                    updateTransactionRequest.checkParams();
                    RepoImpl.this.repository.updateTransaction(updateTransactionRequest);
                    JoinedTransaction joinedTransaction = RepoImpl.this.repository.loadJoinedTransaction(updateTransactionRequest.getTranId());
                    SearchCompanyRequest.Transaction transaction = new SearchCompanyRequest.Transaction(joinedTransaction);
                    transaction.setlCode(updateTransactionRequest.getlCode());
                    transaction.setmCode(updateTransactionRequest.getmCode());
                    ArrayList<SearchCompanyRequest.Transaction> transactions = new ArrayList<SearchCompanyRequest.Transaction>();
                    transactions.add(transaction);
                    SearchCompanyResponse response = RepoImpl.this.api.searchCompany(new SearchCompanyRequest(transactions));
                    if (response != null && response.getResults().size() > 0) {
                        RepoImpl.this.repository.updateTransaction(response.getResults().get(0), updateTransactionRequest.isAll());
                        RepoImpl.this.api.syncTransactions(null);
                    }
                    RepoImpl.this.callback(updateTransactionRequest.getCallbackJS(), true);
                    LocalBroadcastManager.getInstance((Context)RepoImpl.this.activity).sendBroadcast(new Intent("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED"));
                }
                catch (ParameterException e) {
                    RepoImpl.this.callback(updateTransactionRequest.getCallbackJS(), false);
                    RepoImpl.this.onError("updateTransaction", e.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    RepoImpl.this.onError("updateTransaction", e.toString());
                }
            }
        }).start();
    }

    @Override
    @JavascriptInterface
    public boolean shouldShowTranPopup() {
        return this.repository.shouldShowTranPopup();
    }

    @Override
    @JavascriptInterface
    public void setTranPopup(boolean shouldShow) {
        this.repository.setTranPopup(shouldShow);
    }
}

