package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;
import java.util.ArrayList;

import static com.tenqube.visual_third.util.Validator.isStr;
import static com.tenqube.visual_third.util.Validator.notNull;

public class SelectBoxRequest extends Request implements Serializable {

    private String title;

    private String selectedColor;

    private ArrayList<SelectBoxInfo> data;

    private String dataCallbackJS;

    public String getSelectedColor() {
        return selectedColor;
    }

    public String getTitle() {
        return title;
    }

    public ArrayList<SelectBoxInfo> getData() {
        return data;
    }

    public String getDataCallbackJS() {
        return dataCallbackJS;
    }

    @Override
    public void checkParams() throws ParameterException {
        notNull(data);
        isStr(dataCallbackJS, 100);
    }
}
