package com.tenqube.visual_third.web;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v7.app.AlertDialog;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Utils;

import static com.tenqube.visual_third.util.Validator.isStr;

public class SystemImpl extends Base implements VisualInterface.System  {

    private String callbackNoti;

    public SystemImpl(Context context, ViewContractor contractor, WebView webView, VisualInterface.Error error) {
        super(context, contractor, webView, error);
    }

    public void onNotiCallback(final String json) {
        callbackWithStr(callbackNoti, json);
    }

    AlertDialog notiDialog;
    @JavascriptInterface
    public void startNotiListener(final String callback) {

        String funcName = "startNotiListener";
        try {

            isStr(callback, 100);
            // params 파싱해서 callback 구하기
            this.callbackNoti = callback;

            AlertDialog.Builder builder = new AlertDialog.Builder(context);

            builder.setTitle("지금부터 알림을 가계부에 기록합니다.");

            builder.setPositiveButton("다음", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {

                    goNotiSettings(callback);
                    if(notiDialog != null) notiDialog.dismiss();
                }
            });
            notiDialog = builder.create();
            notiDialog.show();
        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public void goNotiSettings(final String callback) {

        String funcName = "goNotiSettings";
        try {

            isStr(callback, 100);
            // params 파싱해서 callback 구하기
            this.callbackNoti = callback;

            try {
                Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
                context.startActivity(intent);

            } catch (ActivityNotFoundException e){
                e.printStackTrace();
                onError(funcName, e.toString());
            }

        } catch (ParameterException e) {
            onError(funcName, e.toString());
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
    }

    @JavascriptInterface
    public boolean isNotiEnabled() {

        String funcName = "isNotiEnabled";
        try {
            return Utils.isNotiEnabled(context);
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
        return false;
    }

    /**
     * 네트워크 연결 여부
     */
    @JavascriptInterface
    public boolean isNetworkConnected() {

        String funcName = "isNetworkConnected";

        try {
            ConnectivityManager cm =
                    (ConnectivityManager)context.getSystemService(Context.CONNECTIVITY_SERVICE);

            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null &&
                    activeNetwork.isConnectedOrConnecting();

            return isConnected;
        } catch (Exception e) {
            e.printStackTrace();
            onError(funcName, e.toString());
        }
        return true;

    }

}
