/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.tenqube.visual_third.entity.VisualNotification;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.VisualNotificationManager;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class AlarmReceiver
extends BroadcastReceiver {
    protected static final String TAG = AlarmReceiver.class.getSimpleName();
    public static final String ACTION_TENQUBE_NOTIFICATION = "ACTION_TENQUBE_NOTIFICATION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        if ("android.intent.action.BOOT_COMPLETED".equals(intent.getAction()) || "android.intent.action.LOCKED_BOOT_COMPLETED".equals(intent.getAction())) {
            VisualAlarmManager.getInstance(context).setAlarms();
        } else if (ACTION_TENQUBE_NOTIFICATION.equals(intent.getAction())) {
            LogUtil.LOGI((String)"ALARM", (String)("Bundle" + intent.getBundleExtra("bundle")), (boolean)true);
            try {
                Bundle bundle = intent.getBundleExtra("bundle");
                if (bundle != null) {
                    VisualNotification notification = (VisualNotification)bundle.getSerializable("data");
                    if (notification != null) {
                        VisualNotificationManager.getInstance(context).showNotification(notification);
                    } else {
                        LogUtil.LOGI((String)TAG, (String)"notification == null", (boolean)ParserService.mIsDebug);
                    }
                } else {
                    LogUtil.LOGI((String)TAG, (String)"bundle == null", (boolean)ParserService.mIsDebug);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                VisualAlarmManager.getInstance(context).syncNotification();
                VisualAlarmManager.getInstance(context).setAlarms();
            }
        }
    }
}

