/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.ui;

import android.text.TextUtils;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.parser.Transaction;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;

public class TransactionPopupInfo
implements Serializable {
    private Transaction transaction;
    private SearchCompanyResponse.TranCompany tranCompany;

    public TransactionPopupInfo(Transaction transaction, SearchCompanyResponse.TranCompany tranCompany) {
        this.transaction = transaction;
        this.tranCompany = tranCompany;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public int getLargeCode() {
        try {
            if (this.tranCompany != null) {
                return Integer.parseInt(this.tranCompany.getCategory().getLargeCode());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public String getCategoryCode() {
        if (this.tranCompany != null) {
            return this.tranCompany.getCategory().getCode();
        }
        return this.transaction.getCategoryCode();
    }

    public String getCompanyTitle() {
        return this.tranCompany == null ? "" : (this.tranCompany.isPopUpCompanyName() ? this.tranCompany.getCompany().getName() : this.transaction.getParsedTransaction().keyword);
    }

    public String getCompanyAddress() {
        return this.tranCompany == null ? "" : (this.tranCompany.isPopUpCompanyName() ? this.tranCompany.getCompany().getAddress() : "");
    }

    public String getSpentDate() {
        return this.transaction == null ? "" : this.transaction.getParsedTransaction().spentDate;
    }

    public String getPayment() {
        if (this.transaction == null) {
            return "";
        }
        String payment = this.transaction.getParsedTransaction().cardName;
        if (!TextUtils.isEmpty((CharSequence)this.transaction.getParsedTransaction().cardNum)) {
            payment = payment + " " + this.transaction.getParsedTransaction().cardNum;
        }
        return payment;
    }

    public int getInstallmentCnt() {
        return this.transaction == null ? 1 : this.transaction.getParsedTransaction().installmentCount;
    }

    public String getInstallmentStr() {
        int instCnt = this.getInstallmentCnt();
        return instCnt == 1 || instCnt == 0 ? "\uc77c\uc2dc\ubd88" : instCnt + "\uac1c\uc6d4";
    }

    public double getSpentMoney() {
        if (this.transaction == null) {
            return 0.0;
        }
        return this.transaction.getSpentMoney();
    }

    public String getSpentMoneyStr() {
        return Utils.threeComma(this.getSpentMoney());
    }
}

