/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualActivityFragment;
import com.tenqube.visual_third.util.ActivityUtils;
import com.tenqube.visual_third.util.Validator;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualServiceImpl
implements VisualService {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    private PrefManager prefManager;
    private Context context;
    private ParserService parserService;
    private boolean isDoingStartVisual;

    public VisualServiceImpl(@NonNull Context context, String apiKey, String qualifier) throws ParameterException {
        if (TextUtils.isEmpty((CharSequence)apiKey)) {
            throw new ParameterException("apiKey is null");
        }
        if (TextUtils.isEmpty((CharSequence)qualifier) || !"dev".equals(qualifier) && !"prod".equals(qualifier)) {
            throw new ParameterException("check qualifier value (dev, prod)");
        }
        this.context = context;
        AnswerManager.initFabric(context);
        VisualRepository.getInstance(context);
        this.prefManager = PrefManager.getInstance(context);
        this.prefManager.saveStringValue("TENQUBE_API_KEY", apiKey);
        this.prefManager.saveStringValue("TENQUBE_QUALIFIER", qualifier);
        this.parserService = ParserService.getInstance((Context)context);
    }

    @Override
    public void startVisual(@NonNull AppCompatActivity activity, int containerId, boolean isBackStack, @NonNull String uid, @NonNull String path) throws ParameterException, SecurityException {
        LogUtil.LOGI((String)TAG, (String)"\uc6f9 \uac00\uacc4\ubd80 \ud638\ucd9c", (boolean)ParserService.mIsDebug);
        try {
            if (this.isDoingStartVisual) {
                return;
            }
            this.isDoingStartVisual = true;
            Validator.notNull(activity);
            Validator.notNull(path);
            Validator.notZero(containerId);
            this.checkSMSPermission();
            AnswerManager.onKeyMetric(new LogRequest("startVisual"));
            ActivityUtils.addFragmentToActivity(activity.getSupportFragmentManager(), VisualActivityFragment.newInstance(uid, path), containerId, VisualActivityFragment.TAG, isBackStack);
        }
        catch (ParameterException | SecurityException e) {
            throw e;
        }
        finally {
            this.isDoingStartVisual = false;
        }
    }

    @Override
    public void setDeepLink(String url) {
        this.prefManager.saveStringValue("TENQUBE_DEEP_LINK", url);
    }

    @Override
    public boolean isActiveTranPopup() {
        AnswerManager.onKeyMetric(new LogRequest("isActiveTranPopup"));
        return this.prefManager.isEnabled("TENQUBE_TRAN_POPUP", true);
    }

    @Override
    public void setTranPopup(boolean isActive) {
        AnswerManager.onKeyMetric(new LogRequest("setTranPopup"));
        this.prefManager.saveBoolean("TENQUBE_TRAN_POPUP", isActive);
    }

    private void checkSMSPermission() throws SecurityException {
        if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false) && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.RECEIVE_SMS") != 0 && ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.RECEIVE_MMS") != 0) {
            throw new SecurityException("Please grant permissions (Manifest.permission.READ_SMS, Manifest.permission.RECEIVE_SMS, Manifest.permission.RECEIVE_MMS)");
        }
    }

    @Override
    public void setDebugMode(boolean isDebug) {
        LogUtil.LOGI((String)TAG, (String)"setDebugMode", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.setDebugMode(isDebug);
        }
    }

    @Override
    public void initSDK() {
        LogUtil.LOGI((String)TAG, (String)"initSDK", (boolean)ParserService.mIsDebug);
        if (this.isActive() && this.parserService != null) {
            this.parserService.initDb();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.prefManager.saveBoolean("TENQUBE_SDK_ENABLED", enabled);
    }

    private boolean isActive() {
        return this.context != null;
    }
}

