package com.tenqube.visual_third.web;

import android.content.Context;
import android.text.TextUtils;
import android.webkit.WebView;

import static com.tenqube.visual_third.util.Utils.toJson;

public class Base {

    final Context context;
    final ViewContractor contractor;
    final WebView webView;
    final VisualInterface.Error error;

    public Base(Context context, ViewContractor contractor, WebView webView, VisualInterface.Error error) {
        this.context = context;
        this.contractor = contractor;
        this.webView = webView;
        this.error = error;
    }


    String getJs(String callback, String data) {
        if(!TextUtils.isEmpty(data)) data = "'" + data + "'";
        return "javascript:window." + callback + "(" + data + ");";
    }


    void callback(final String callback, final Object object) {

        try {
            webView.post(new Runnable() {
                @Override
                public void run() {
                    webView.loadUrl(getJs(callback, object == null ? "" : toJson(object)));
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    void callbackWithStr(final String callback, final String value) {

        try {
            webView.post(new Runnable() {
                @Override
                public void run() {
                    webView.loadUrl(getJs(callback, value));
                }
            });

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    void onError(String fucName, String msg) {
        if(error != null) error.onError(fucName, msg);
    }
}
