/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api.resource;

import com.tenqube.visual_third.api.resource.ResourceApi;
import com.tenqube.visual_third.api.resource.ResourceService;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.NotificationPkgResponse;
import com.tenqube.visual_third.model.api.NotificationResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.VersionResponse;
import java.io.IOException;
import retrofit2.Response;
import tenqube.parser.model.ParsingRule;

public class ResourceServiceImpl
implements ResourceService {
    private static final String TAG = ResourceServiceImpl.class.getSimpleName();
    private final ResourceApi resourceApi;
    private static ResourceService mInstance;

    private ResourceServiceImpl(ResourceApi resourceApi) {
        this.resourceApi = resourceApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceService getInstance(ResourceApi resourceApi) {
        Class<ResourceServiceImpl> clazz = ResourceServiceImpl.class;
        synchronized (ResourceServiceImpl.class) {
            if (mInstance == null) {
                mInstance = new ResourceServiceImpl(resourceApi);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public VersionResponse syncVersion() {
        try {
            Response response = this.resourceApi.syncVersion().execute();
            if (response != null && response.isSuccessful()) {
                return (VersionResponse)response.body();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public SyncCategoryResponse syncCategory(int clientVersion, int serverVersion) {
        if (serverVersion > clientVersion) {
            try {
                Response response = this.resourceApi.syncCategory("category", clientVersion, serverVersion).execute();
                if (response.isSuccessful()) {
                    return (SyncCategoryResponse)response.body();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public NotificationPkgResponse syncNotificationApps() {
        try {
            Response response = this.resourceApi.syncNotificationApps().execute();
            if (response.isSuccessful()) {
                return (NotificationPkgResponse)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public AnalysisResponse syncAnalysis(int clientVersion, int serverVersion) {
        if (serverVersion > clientVersion) {
            try {
                Response response = this.resourceApi.syncAnalysis("analysis", clientVersion, serverVersion).execute();
                if (response.isSuccessful()) {
                    return (AnalysisResponse)response.body();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public NotificationResponse syncNotification() {
        try {
            Response response = this.resourceApi.syncNotification().execute();
            if (response.isSuccessful()) {
                return (NotificationResponse)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ParsingRule syncParsingRule(int clientVersion, int serverVersion) {
        try {
            Response ruleResponse;
            if (serverVersion > clientVersion && (ruleResponse = this.resourceApi.syncParsingRule("parsingRule", clientVersion, serverVersion).execute()).isSuccessful()) {
                return (ParsingRule)ruleResponse.body();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ParsingRuleKey syncParsingRuleKey() {
        try {
            Response response = this.resourceApi.syncParsingRuleKey().execute();
            if (response != null && response.isSuccessful()) {
                return (ParsingRuleKey)response.body();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

