package com.tenqube.visual_third.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.entity.NotificationApp;
import com.tenqube.visual_third.repository.RepositoryHolder;
import com.tenqube.visual_third.repository.VisualRepository;

import java.util.ArrayList;


public class NotiCatchDialogFragment extends DialogFragment {

    public static final String TAG = NotiCatchDialogFragment.class.getSimpleName();

    public static final String ARG_TITLE = "ARG_TITLE";
    private AppAdapter appAdapter;
    private RecyclerView recyclerView;
    private VisualRepository repository;

    private Callback callback;

    private String title;

    public NotiCatchDialogFragment() {
        super();
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public interface Callback {
        void onClickNext();
    }


    public static NotiCatchDialogFragment newInstance(String title) {
        NotiCatchDialogFragment fragment = new NotiCatchDialogFragment();

        Bundle bundle = new Bundle();
        bundle.putString(ARG_TITLE, title);

        fragment.setArguments(bundle);

        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Bundle bundle = getArguments();
        if(bundle != null) {
            title = bundle.getString(ARG_TITLE);
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        try {

            android.app.AlertDialog.Builder builder = new android.app.AlertDialog.Builder(new ContextThemeWrapper(getActivity(), android.R.style.Theme_Holo));
            View view = getActivity().getLayoutInflater().inflate(R.layout.dialog_noti_catch,null);

            TextView titleTextView = view.findViewById(R.id.title);

            if(!TextUtils.isEmpty(title))
                titleTextView.setText(title);

            repository = RepositoryHolder.getInstance(getActivity()).getVisualRepository();

            Dialog dialog = builder.create();
            ((AlertDialog) dialog).setView(view, 0, 0, 0, 0);
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
//        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCanceledOnTouchOutside(true);
            if(dialog.getWindow() != null) dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);

            recyclerView = (RecyclerView) view.findViewById(R.id.recyclerView);
            appAdapter = new AppAdapter(Glide.with(getActivity()));
            recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));
            recyclerView.setAdapter(appAdapter);

            new LoadTask().execute();

            Button nextButton = view.findViewById(R.id.next);
            nextButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if(callback != null) {
                        callback.onClickNext();
                    }
                    dismissAllowingStateLoss();
                }
            });

            return dialog;
        } catch (Exception e) {
            e.printStackTrace();
            dismissAllowingStateLoss();
        }

        return null;

    }

    @Override
    public void onStart() {
        super.onStart();
//        Dialog dialog = getDialog();
//        if (dialog != null && dialog.getWindow() != null) {
//            dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
//            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
//        }
    }

    public class LoadTask extends AsyncTask<Void, Void, ArrayList<NotificationApp>> {

        @Override
        protected ArrayList<NotificationApp> doInBackground(Void... voids) {

            return repository.loadNotiCatchedApps();
        }

        @Override
        protected void onPostExecute(ArrayList<NotificationApp> notiCatches) {
            super.onPostExecute(notiCatches);
            appAdapter.addAll(notiCatches);
        }
    }

    public static class AppAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder>  {

        ArrayList<NotificationApp> apps = new ArrayList<>();
        private final RequestManager requestManager;
        public AppAdapter(RequestManager requestManager) {
            this.requestManager = requestManager;
        }

        public void addAll(ArrayList<NotificationApp> smsList) {
            this.apps = smsList;
            notifyDataSetChanged();
        }

        @Override
        public NotiCatchViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_noti, parent,false);
            return new NotiCatchViewHolder(v);
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            NotificationApp notiCatch = apps.get(position);
            NotiCatchViewHolder notiCatchViewHolder = ((NotiCatchViewHolder)holder);
            requestManager.load(notiCatch.getImage()).into(notiCatchViewHolder.icon);
            notiCatchViewHolder.appName.setText(notiCatch.getName());

        }

        @Override
        public int getItemCount() {
            return apps == null ? 0 : apps.size();
        }

        public static class NotiCatchViewHolder extends RecyclerView.ViewHolder {

            private ImageView icon;
            private TextView appName;

            public NotiCatchViewHolder(View itemView) {
                super(itemView);
                icon = (ImageView)itemView.findViewById(R.id.icon);
                appName = (TextView)itemView.findViewById(R.id.app_name);

            }
        }
    }

}