package com.tenqube.visual_third.model.api;

import com.tenqube.visual_third.api.data.Token;

import java.io.Serializable;

public class UserResult implements Serializable {

    private ExternalApi search;
    private ExternalApi resource;

    private Web web;
    private Authorization authorization;

    public Web getWeb() {
        return web;
    }

    public ExternalApi getResource() {
        return resource;
    }

    public ExternalApi getSearch() {
        return search;
    }

    public Authorization getAuthorization() {
        return authorization;
    }


    public static class ExternalApi implements Serializable {
        private String url;
        private String apiKey;

        public String getUrl() {
            return url;
        }

        public String getApiKey() {
            return apiKey;
        }

        @Override
        public String toString() {
            return "Search{" +
                    "url='" + url + '\'' +
                    ", apiKey='" + apiKey + '\'' +
                    '}';
        }
    }

    public static class Web implements Serializable {
        private String url;

        public String getUrl() {
            return url;
        }
    }

    public static class Authorization implements Serializable {

        private Token sdk;

        public Token getSdk() {
            return sdk;
        }

        @Override
        public String toString() {
            return "Authorization{" +
                    "sdk='" + sdk + '\'' +
                    '}';
        }
    }


}
