package com.tenqube.visual_third.manager;

import android.content.Context;
import android.text.TextUtils;

import com.mobon.sdk.MobonSDK;
import com.mobon.sdk.callback.iMobonAdCallback;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.R;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.Serializable;

public class MobonManager {

    private static  final String MEDIA_CODE = "ionebank";
    private static  final String UNIT_ID = "42502";

    private final Context context;
    private final MobonSDK mobonSDK;

    public MobonManager(Context context) {

        this.context = context;
        mobonSDK = new MobonSDK(context.getApplicationContext(), MEDIA_CODE);

    }

    public void onImpression() {
        try {
            mobonSDK.onImpression();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadAd(final Callback<AdItem> callback) {

        if(mobonSDK != null) {
            mobonSDK.setIMobonAdCallback(new iMobonAdCallback() {

                @Override
                public void onLoadedMobonAdData(boolean result, JSONObject objData, String errorStr) {
                    AdItem adItem = null;
                    try {
                        if (result) {
                            JSONObject jObj = objData.getJSONArray("client").getJSONObject(0);
                            JSONArray jArray = jObj.getJSONArray("data");

                            String mobonLogo = jObj.getString("mobonLogo");
                            if(jArray.length() > 0) {
                                adItem = new AdItem(mobonLogo, jArray.getJSONObject(0));
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    } finally {
                        callback.onDataLoaded(adItem);
                    }
                }

            });

            mobonSDK.getMobonAdData(context, 1, UNIT_ID); //두번째 인자 : 받을 광고의 갯수, 세번쟤 인자 : 담당자에게 문의 바랍니다.
        } else {
            callback.onDataLoaded(null);
        }

    }

    public class AdItem implements Serializable {
        public String imgUrl;
        public String title;
        public String desc;
        public String landingUrl;
        public String price;
        public int layout;
        public String viewKey;
        public String mobonLogo;

        public AdItem(String mobonLogo, JSONObject objData) throws Exception{
            viewKey = objData.optString("increaseViewKey"); //노출 증가 필수 키
            final String pcode = objData.optString("pcode");

            this.mobonLogo = mobonLogo;
            if (TextUtils.isEmpty(pcode)) // 비 타게팅 광고!!
            {
                // 비 타게팅 광고는 여러가지 사이즈의 이미지가 넘어옵니다. mimg 로 시작되는 키값은 비어 있을 수
                // 있습니다. img 키 값을 사용하기를 권장합니다.
                // img, mimg_120_600,mimg_160_300, mimg_160_600,
                // mimg_250_250,mimg_300_65, mimg_300_180, mimg_320_100,
                // mimg_300_250,
                // mimg_640_350,mimg_720_1230, mimg_728_90, mimg_850_800,
                // mimg_800_1500, mimg_960_100
                title = objData.getString("pnm");
                if (TextUtils.isEmpty(objData.getString("site_desc1")))
                    desc = objData.getString("desc");
                else
                    desc = objData.getString("site_desc1");

                title = objData.getString("pnm");
                price = "";

                String[] imgArray = {
                        objData.optString("mimg_720_120"),
                        objData.optString("mimg_728_90"),
                        objData.optString("mimg_250_250"),
                        objData.optString("img")};

                for (int i = 0; i < imgArray.length; i++) {
                    String ext = imgArray[i].substring(imgArray[i].lastIndexOf(".") + 1);
                    if (ext.equals("jpg") || ext.equals("png") || ext.equals("gif")) {
                        imgUrl = imgArray[i];

                        if(i == 2) {
                            layout = R.layout.mobon_view;
                        } else {
                            layout = R.layout.adlist_ad_item;
                        }
                        break;
                    }
                }
            } else {
                // 타게팅 광고 시 img 한 사이즈의 이미지가 내려 받을 수 있으며 상품 이미지에 따라 사이즈가
                // 가변하므로 이미지 영역을 정하고 처리해야 합니다.

                title = objData.getString("pnm");
                desc = objData.getString("site_desc1");
                price = objData.getString("price") + "원";
                imgUrl = objData.getString("img");
                layout = R.layout.mobon_view;
            }

            landingUrl = objData.getString("purl");

            if(TextUtils.isEmpty(imgUrl)) {
                throw new Exception("img is null");
            }


        }

    }
}
