/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.CurrencyManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.repository.VisualRepository;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.ParsingRule;
import tenqube.parser.model.Transaction;

class BaseLoader {
    final Context mContext;
    ParserService parserService;
    VisualApi api;
    PrefManager prefManager;
    VisualRepository repository;
    private CurrencyManager currencyManager;

    BaseLoader(Context context) {
        this.mContext = context;
        this.parserService = ParserService.getInstance((Context)context);
        this.parserService.setDebugMode(true);
        this.api = VisualApi.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
        this.prefManager = PrefManager.getInstance(context);
        this.currencyManager = CurrencyManager.getInstance(context);
    }

    void syncParsingRule() {
        ParsingRule parsingRule = this.api.syncParsingRule(this.prefManager.loadIntValue("TENQUBE_PARSING_RULE_VERSION", 214));
        if (parsingRule != null) {
            this.parserService.syncParsingRule(parsingRule);
            this.prefManager.saveIntValue("TENQUBE_PARSING_RULE_VERSION", parsingRule.ruleVersion);
        }
    }

    void setCurrency(ArrayList<Transaction> transactions) {
        for (Transaction parsedTran : transactions) {
            parsedTran.spentMoney = this.currencyManager.calculateSpentMoney(parsedTran.spentMoney, parsedTran.currency);
        }
    }
}

