/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.web;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import android.widget.Toast;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.js.ConfirmBoxRequest;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.NewViewRequest;
import com.tenqube.visual_third.model.js.PageInfoRequest;
import com.tenqube.visual_third.model.js.SelectBoxInfo;
import com.tenqube.visual_third.model.js.SelectBoxRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.util.GoOpenMarketUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.web.Base;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;

public class UiImpl
extends Base
implements VisualInterface.UI,
BottomDialog.OnBottomListener {
    private String callbackSelectOrderBy;
    private final BottomDialog bottomDialog;

    public UiImpl(Context context, ViewContractor contractor, WebView webView, VisualInterface.Error error, BottomDialog bottomDialog) {
        super(context, contractor, webView, error);
        this.bottomDialog = bottomDialog;
        this.bottomDialog.setBottomListener(this);
    }

    @Override
    @JavascriptInterface
    public void openConfirmBox(String params) {
        String funcName = "openConfirmBox";
        try {
            final ConfirmBoxRequest confirmBoxRequest = Utils.fromJson(params, ConfirmBoxRequest.class);
            confirmBoxRequest.checkParams();
            AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
            builder.setMessage((CharSequence)confirmBoxRequest.getMessage());
            builder.setNegativeButton((CharSequence)confirmBoxRequest.getData().get(0).getButtonText(), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    UiImpl.this.callback(confirmBoxRequest.getData().get(0).getCallbackJS(), null);
                }
            });
            builder.setPositiveButton((CharSequence)confirmBoxRequest.getData().get(1).getButtonText(), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    UiImpl.this.callback(confirmBoxRequest.getData().get(1).getCallbackJS(), null);
                }
            });
            AlertDialog alertDialog = builder.create();
            alertDialog.show();
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void openSelectBox(String params) {
        String funcName = "openSelectBox";
        try {
            SelectBoxRequest selectBoxRequest = Utils.fromJson(params, SelectBoxRequest.class);
            selectBoxRequest.checkParams();
            this.callbackSelectOrderBy = selectBoxRequest.getDataCallbackJS();
            if (this.bottomDialog != null) {
                this.bottomDialog.showBottomDialog(selectBoxRequest);
            }
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    public void onItemSelected(SelectBoxInfo selectBoxInfo) {
        if (this.bottomDialog != null) {
            this.bottomDialog.dismiss();
        }
        this.callback(this.callbackSelectOrderBy, selectBoxInfo);
    }

    @Override
    @JavascriptInterface
    public void openNewView(String params) {
        String funcName = "openNewView";
        try {
            NewViewRequest newViewInfo = Utils.fromJson(params, NewViewRequest.class);
            newViewInfo.checkParams();
            if ("external".equals(newViewInfo.getViewType())) {
                Intent i = new Intent("android.intent.action.VIEW");
                i.setData(Uri.parse((String)newViewInfo.getUrl()));
                this.context.startActivity(i);
            } else if (!"internal".equals(newViewInfo.getViewType()) && "google".equals(newViewInfo.getViewType())) {
                GoOpenMarketUtil.openOnGooglePlayMarket(this.context, newViewInfo.getUrl());
            }
        }
        catch (ParameterException e) {
            this.onError(funcName, e.toString());
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void finish(String path) {
        String funcName = "finish";
        try {
            if (this.contractor != null) {
                this.contractor.onFinish(path);
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void showSnackBar(String msg) {
        try {
            Snackbar.make((View)this.webView, (CharSequence)msg, (int)-1).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void showToast(String msg) {
        try {
            Toast.makeText((Context)this.context, (CharSequence)msg, (int)0).show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void onPageLoaded(String params) {
        try {
            PageInfoRequest page = Utils.fromJson(params, PageInfoRequest.class);
            page.checkParams();
            if (this.contractor != null) {
                this.contractor.onPageLoaded();
            }
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void onScrollChanged(int pos) {
        try {
            if (this.contractor != null) {
                this.contractor.onScrollChanged(pos);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void onFinish() {
        String funcName = "onFinish";
        try {
            this.callback("onFinish", null);
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void showDatePicker(String params) {
        String funcName = "showMonthPicker";
        try {
            DateRequest dateRequest = Utils.fromJson(params, DateRequest.class);
            dateRequest.checkParams();
            if (this.contractor != null) {
                this.contractor.showDatePicker(dateRequest);
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void showTimePicker(String params) {
        String funcName = "showTimePicker";
        try {
            TimeRequest timeRequest = Utils.fromJson(params, TimeRequest.class);
            timeRequest.checkParams();
            if (this.contractor != null) {
                this.contractor.showTimePicker(timeRequest);
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void reload() {
        String funcName = "reload";
        try {
            if (this.contractor != null) {
                this.contractor.reload();
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void retry() {
        String funcName = "retry";
        try {
            if (this.contractor != null) {
                this.contractor.retry();
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    @JavascriptInterface
    public void setRefreshEnabled(boolean enabled) {
        String funcName = "setRefreshEnabled";
        try {
            if (this.contractor != null) {
                this.contractor.setRefreshEnabled(enabled);
            }
        }
        catch (Exception e) {
            this.onError(funcName, e.toString());
        }
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.callbackWithStr(callback, date);
    }
}

