/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api;

import android.content.Context;
import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.tenqube.visual_third.api.VisualApiService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.AdResponse;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.CurrencyResponse;
import com.tenqube.visual_third.model.api.ParsingRuleKey;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.model.api.VersionResponse;
import com.tenqube.visual_third.model.js.AdRequest;
import com.tenqube.visual_third.repository.AnalysisRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.model.ParsingRule;

public class VisualApi {
    public static final String TAG = VisualApi.class.getSimpleName();
    public static VisualApi mInstance;
    private Context context;
    private VisualApiService visualApiService;
    private PrefManager prefManager;
    private VisualRepository repository;
    private AnalysisRepository analysisRepository;
    public static final int API_KEY = 0;
    public static final int AUTHORIZATION = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualApi getInstance(Context context) {
        Class<VisualApi> clazz = VisualApi.class;
        synchronized (VisualApi.class) {
            if (mInstance == null) {
                mInstance = new VisualApi(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualApi(Context context) {
        this.context = context;
        this.prefManager = PrefManager.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
        this.analysisRepository = AnalysisRepository.getInstance(context);
    }

    private VisualApiService getApiService() {
        if (this.visualApiService == null) {
            this.visualApiService = (VisualApiService)this.provideRetrofit(this.getUrl()).create(VisualApiService.class);
        }
        return this.visualApiService;
    }

    public String[] getAuthInfo() {
        return new String[]{this.prefManager.loadStringValue("TENQUBE_API_KEY", ""), this.prefManager.loadStringValue("TENQUBE_UID", "")};
    }

    private String[] getSearchAuthInfo() {
        return new String[]{this.prefManager.loadStringValue("TENQUBE_SEARCH_API_KEY", ""), this.prefManager.loadStringValue("TENQUBE_UID", "")};
    }

    private String getUrl() {
        String url = this.prefManager.loadStringValue("TENQUBE_API_URL", "https://richnco.tenqube.kr/") + this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev") + "/";
        return url;
    }

    private Retrofit provideRetrofit(String url) {
        return new Retrofit.Builder().baseUrl(url).client(this.provideOkHttpClient()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson())).build();
    }

    private OkHttpClient provideOkHttpClient() {
        OkHttpClient.Builder okhttpClientBuilder = new OkHttpClient.Builder();
        okhttpClientBuilder.connectTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.readTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.writeTimeout(5L, TimeUnit.SECONDS);
        return okhttpClientBuilder.build();
    }

    public SignUpResponse signUp(SignUpRequest signUpInfo) {
        try {
            Response response = this.getApiService().signUp(this.getAuthInfo()[0], signUpInfo).execute();
            if (response.isSuccessful()) {
                return (SignUpResponse)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public VersionResponse syncVersion(String apiKey) {
        try {
            Response response = this.getApiService().syncVersion(apiKey).execute();
            if (response.isSuccessful()) {
                return (VersionResponse)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void syncCategory(String[] authInfo, int version) {
        try {
            SyncCategoryResponse categoryResponse;
            Response response = this.getApiService().syncCategory(authInfo[0], authInfo[1], version).execute();
            if (response.isSuccessful() && (categoryResponse = (SyncCategoryResponse)response.body()) != null) {
                this.prefManager.saveIntValue("TENQUBE_CATEGORY_VERSION", categoryResponse.getVersion());
                if (!categoryResponse.getCategories().isEmpty()) {
                    this.repository.mergeCategory(categoryResponse.getCategories());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ParsingRule syncParsingRule(int version) {
        try {
            String[] authInfo = this.getAuthInfo();
            Response response = this.getApiService().syncParsingRule(authInfo[0], authInfo[1], version).execute();
            if (response.isSuccessful()) {
                return (ParsingRule)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ParsingRuleKey syncParsingRuleKey() {
        try {
            String[] authInfo = this.getAuthInfo();
            Response response = this.getApiService().syncParsingRuleKey(authInfo[0]).execute();
            if (response.isSuccessful()) {
                return (ParsingRuleKey)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void syncAnalysis(String[] authInfo, int version) {
        try {
            AnalysisResponse analysisResponse;
            Response response = this.getApiService().syncAnalysis(authInfo[0], authInfo[1], version).execute();
            if (response.isSuccessful() && (analysisResponse = (AnalysisResponse)response.body()) != null) {
                this.prefManager.saveIntValue("TENQUBE_ANALYSIS_VERSION", analysisResponse.getVersion());
                if (!Utils.isEmpty(analysisResponse.getContents())) {
                    this.analysisRepository.mergeAnalysis(analysisResponse.getContents());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SearchCompanyResponse searchCompany(@NonNull SearchCompanyRequest searchCompanyRequest) {
        try {
            String[] searchAuthInfo = this.getSearchAuthInfo();
            String searchUrl = this.prefManager.loadStringValue("TENQUBE_SEARCH_URL", "");
            Response response = this.getApiService().searchCompany(searchAuthInfo[0], searchAuthInfo[1], searchUrl, searchCompanyRequest).execute();
            if (response.isSuccessful()) {
                this.repository.updateRetrySearch(searchCompanyRequest.getTransactions(), false);
                return (SearchCompanyResponse)response.body();
            }
            if (response.code() == 499 || response.code() == 500) {
                this.repository.updateRetrySearch(searchCompanyRequest.getTransactions(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void saveTransactions(@NonNull TransactionRequest transactionRequest, Callback<Void> callback) {
        String[] authInfo = this.getAuthInfo();
        Call<Void> call = this.getApiService().saveTransactions(authInfo[0], authInfo[1], transactionRequest);
        call.enqueue(callback);
    }

    public void syncTransactions(final OnNetworkResultListener callback) {
        final TransactionRequest transactionRequest = this.repository.loadNotSyncedTransactions();
        if (transactionRequest != null && !Utils.isEmpty(transactionRequest.getTransactions())) {
            this.saveTransactions(transactionRequest, new Callback<Void>(){

                public void onResponse(Call<Void> call, Response<Void> response) {
                    if (response.isSuccessful() || response.code() == 400) {
                        VisualApi.this.repository.updateSyncedTransactions(transactionRequest);
                        VisualApi.this.repository.deleteTransactions();
                    }
                    if (callback != null) {
                        callback.onResult(true);
                    }
                }

                public void onFailure(Call<Void> call, Throwable t) {
                    if (callback != null) {
                        callback.onResult(true);
                    }
                }
            });
        } else if (callback != null) {
            callback.onResult(true);
        }
    }

    public double getCurrencyRate(String from, String to, double localRate) {
        try {
            CurrencyResponse currencyResponse;
            String[] authInfo = this.getAuthInfo();
            Response response = this.getApiService().callCurrencyRate(authInfo[0], authInfo[1], from.toLowerCase(), to.toLowerCase()).execute();
            if (response.isSuccessful() && (currencyResponse = (CurrencyResponse)response.body()) != null) {
                this.repository.mergeCurrency(from, to, currencyResponse.getRate(), Utils.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance()));
                return currencyResponse.getRate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return localRate;
    }

    public void getAds(AdRequest adRequest, Callback<AdResponse> callback) {
        try {
            String[] authInfo = this.getAuthInfo();
            Call<AdResponse> call = this.getApiService().getAds(authInfo[0], adRequest.getWhere());
            call.enqueue(callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

