package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import androidx.annotation.NonNull;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.VisualNotification;

import java.util.ArrayList;

public class NotificationDao {

    private final Db db;

    public NotificationDao(Db db) {
        this.db = db;
    }

    public boolean isActiveNoti(String name) {

        String query = QueryGenerator.isActive();
        Cursor c = null;
        int enabled = 0;

        try {
            String[] args = new String[]{"%" + name + "%"};

            c = db.runQuery(query, args);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        enabled = c.getInt(0);
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return enabled == 1;
    }

    public void setActiveNoti(String name, boolean isActive) {

        try {
            ContentValues values = new ContentValues();
            values.put(ReaderContract.NotificationsTable.COLUMN_ENABLE, isActive ? 1 : 0);
            db.update(ReaderContract.NotificationsTable.TABLE_NAME, values, ReaderContract.NotificationsTable.COLUMN_NAME + " like ?" , new String[]{"%"+name+"%"});
        } catch (Exception e) {

        }
    }

    public void updateNotiHour(String name, int hour) {

        try {
            ContentValues values = new ContentValues();
            values.put(ReaderContract.NotificationsTable.COLUMN_HOUR, hour);
            db.update(ReaderContract.NotificationsTable.TABLE_NAME, values, ReaderContract.NotificationsTable.COLUMN_NAME + "=?" , new String[]{name});
        } catch (Exception e) {

        }

    }

    public void updateNotiStatus(int id, boolean enabled) {

        try {
            ContentValues values = new ContentValues();
            values.put(ReaderContract.NotificationsTable.COLUMN_ENABLE, enabled ? 1 : 0);
            db.update(ReaderContract.NotificationsTable.TABLE_NAME, values, ReaderContract.NotificationsTable.COLUMN_NOTI_ID + "=?" , new String[]{"" + id});

        } catch (Exception e) {

        }

    }

    public VisualNotification loadNotification(String name) {
        String query = QueryGenerator.notificationByName();
        Cursor c = null;


        try {
            String[] args = new String[]{"%" + name + "%"};

            c = db.runQuery(query, args);
            if(c != null) {
                if(c.moveToFirst()) {
                    return ReaderContract.NotificationsTable.populateModel(c);
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }
        return null;
    }

    public ArrayList<VisualNotification> loadNotifications() {
        String query = QueryGenerator.notification();
        ArrayList<VisualNotification> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.NotificationsTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public VisualNotification loadNotification(int id) {
        String query = QueryGenerator.notificationById();
        VisualNotification result = null;
        Cursor c = null;

        try {
            c = db.runQuery(query, new String[]{id + ""});
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        result = ReaderContract.NotificationsTable.populateModel(c);
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return result;
    }

    public void updateAllNotiEnable(boolean isActive) {
        try {

            ContentValues values = new ContentValues();
            values.put(ReaderContract.NotificationsTable.COLUMN_ENABLE, isActive ? 1 : 0);
            db.update(ReaderContract.NotificationsTable.TABLE_NAME, values, null , null);
        } catch (Exception e) {

        }
    }

    public void mergeNotifications(@NonNull ArrayList<VisualNotification> notifications) {

        try {
            for(VisualNotification notification : notifications) {
                ContentValues values = ReaderContract.NotificationsTable.populateContent(notification);
                db.insertOnReplace(ReaderContract.NotificationsTable.TABLE_NAME, values);
            }

        } catch (Exception e) {

        }

    }
}
