package com.tenqube.visual_third.model.ui;

import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.js.Receipt;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Utils.threeComma;

public class TransactionPopupInfo implements Serializable {

    private final JoinedTransaction transaction;
    private final SearchCompanyResponse.TranCompany tranCompany;

    public TransactionPopupInfo(JoinedTransaction transaction,
                                SearchCompanyResponse.TranCompany tranCompany) {
        this.transaction = transaction;
        this.tranCompany = tranCompany;
    }

    public JoinedTransaction getTransaction() {
        return transaction;
    }

    public SearchCompanyResponse.TranCompany getTranCompany() {
        return tranCompany;
    }

    public String getCategoryCode() {
        if(tranCompany != null) {
            return tranCompany.getCategory().getCode();
        } else {
            return transaction.getCategory().getCode() + "";
        }
    }

    public String getCompanyTitle() {
        return tranCompany == null ? "" : tranCompany.isPopUpCompanyName() ? tranCompany.getCompany().getName() : transaction.getTransaction().getKeyword();
    }

    public String getCompanyAddress() {
        return tranCompany == null ? "" : tranCompany.isPopUpCompanyName() ? tranCompany.getCompany().getAddress() : "";
    }

    public String getSpentDate() {
        return transaction == null ? "" : transaction.getTransaction().getSpentDate();
    }

    public String getPayment() {
        if(transaction == null) return "";
        String payment = transaction.getCard().getChangeName();
        return payment;
    }

    public int getInstallmentCnt() {
        return transaction == null ? 1 :transaction.getTransaction().getInstallmentCnt();
    }

    public String getInstallmentStr() {
        int instCnt = getInstallmentCnt();
        return instCnt == 1 || instCnt == 0 ? "일시불" : instCnt + "개월";
    }

    public double getSpentMoney() {
        if(transaction == null) return 0;

        return transaction.getTransaction().getSpentMoney();
    }

    public String getSpentMoneyStr() {
        return threeComma(getSpentMoney());
    }

    public Receipt toReceipt() {

        return new Receipt(this.getTransaction().getTransaction().getId(),
                getCompanyTitle(),
                getCompanyAddress(),
                this.getTransaction().getTransaction().getKeyword(),
                this.getTransaction().getTransaction().getInstallmentCnt(),
                this.getTransaction().getTransaction().getDwType(),
                this.getTransaction().getTransaction().getSpentMoney(),
                this.getTransaction().getTransaction().getSpentDate(),
                this.getTransaction().getTransaction().getCurrency(),
                this.getTransaction().getCategory().getLarge(),
                this.getTransaction().getCategory().getMedium(),
                this.getTransaction().getCategory().getSmall(),
                this.getTranCompany().getCompany().getName(),
                this.getTranCompany().getCompany().getAddress(),
                this.getTranCompany().isPopUpCompanyName(),
                this.getTransaction().getCard().getChangeName(),
                this.getTransaction().getCard().getChangeType(),
                this.getTransaction().getCard().getChangeSubType());

    }
}